/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.TextMapPropagatorAndName;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.TextMapPropagatorModel;
import java.util.Collections;
import java.util.Map;

final class TextMapPropagatorFactory
implements Factory<TextMapPropagatorModel, TextMapPropagatorAndName> {
    private static final TextMapPropagatorFactory INSTANCE = new TextMapPropagatorFactory();

    private TextMapPropagatorFactory() {
    }

    static TextMapPropagatorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public TextMapPropagatorAndName create(TextMapPropagatorModel model, DeclarativeConfigContext context) {
        if (model.getTracecontext() != null) {
            return TextMapPropagatorFactory.getPropagator(context, "tracecontext");
        }
        if (model.getBaggage() != null) {
            return TextMapPropagatorFactory.getPropagator(context, "baggage");
        }
        if (model.getB3() != null) {
            return TextMapPropagatorFactory.getPropagator(context, "b3");
        }
        if (model.getB3multi() != null) {
            return TextMapPropagatorFactory.getPropagator(context, "b3multi");
        }
        if (model.getJaeger() != null) {
            return TextMapPropagatorFactory.getPropagator(context, "jaeger");
        }
        if (model.getOttrace() != null) {
            return TextMapPropagatorFactory.getPropagator(context, "ottrace");
        }
        Map.Entry<String, Object> keyValue = FileConfigUtil.getSingletonMapEntry(model.getAdditionalProperties(), "propagator");
        TextMapPropagator propagator = context.loadComponent(TextMapPropagator.class, keyValue.getKey(), keyValue.getValue());
        return TextMapPropagatorAndName.create(propagator, keyValue.getKey());
    }

    static TextMapPropagatorAndName getPropagator(DeclarativeConfigContext context, String name) {
        Object textMapPropagator = name.equals("tracecontext") ? W3CTraceContextPropagator.getInstance() : (name.equals("baggage") ? W3CBaggagePropagator.getInstance() : context.loadComponent(TextMapPropagator.class, name, Collections.emptyMap()));
        return TextMapPropagatorAndName.create((TextMapPropagator)textMapPropagator, name);
    }
}

