/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.internal.ConfigUtil;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.TlsConfigHelper;
import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.compression.CompressorUtil;
import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.grpc.GrpcSenderConfig;
import io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import io.opentelemetry.sdk.internal.ComponentId;
import io.opentelemetry.sdk.internal.StandardComponentId;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class GrpcExporterBuilder<T extends Marshaler> {
    public static final long DEFAULT_CONNECT_TIMEOUT_SECS = 10L;
    private static final Logger LOGGER = Logger.getLogger(GrpcExporterBuilder.class.getName());
    private final StandardComponentId.ExporterType exporterType;
    private final String grpcEndpointPath;
    private final Supplier<BiFunction<Channel, String, MarshalerServiceStub<T, ?, ?>>> grpcStubFactory;
    private long timeoutNanos;
    private long connectTimeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private URI endpoint;
    @Nullable
    private Compressor compressor;
    private final Map<String, String> constantHeaders = new HashMap<String, String>();
    private Supplier<Map<String, String>> headerSupplier = Collections::emptyMap;
    private TlsConfigHelper tlsConfigHelper = new TlsConfigHelper();
    @Nullable
    private RetryPolicy retryPolicy = RetryPolicy.getDefault();
    private Supplier<MeterProvider> meterProviderSupplier = () -> GlobalOpenTelemetry.getOrNoop().getMeterProvider();
    private InternalTelemetryVersion internalTelemetryVersion = InternalTelemetryVersion.LEGACY;
    private ComponentLoader componentLoader = ComponentLoader.forClassLoader((ClassLoader)GrpcExporterBuilder.class.getClassLoader());
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private Object grpcChannel;

    public GrpcExporterBuilder(StandardComponentId.ExporterType exporterType, long defaultTimeoutSecs, URI defaultEndpoint, Supplier<BiFunction<Channel, String, MarshalerServiceStub<T, ?, ?>>> grpcStubFactory, String grpcEndpointPath) {
        this.exporterType = exporterType;
        this.grpcEndpointPath = grpcEndpointPath;
        this.timeoutNanos = TimeUnit.SECONDS.toNanos(defaultTimeoutSecs);
        this.endpoint = defaultEndpoint;
        this.grpcStubFactory = grpcStubFactory;
    }

    public GrpcExporterBuilder<T> setChannel(ManagedChannel channel) {
        this.grpcChannel = channel;
        return this;
    }

    public GrpcExporterBuilder<T> setTimeout(long timeout, TimeUnit unit) {
        this.timeoutNanos = timeout == 0L ? Long.MAX_VALUE : unit.toNanos(timeout);
        return this;
    }

    public GrpcExporterBuilder<T> setTimeout(Duration timeout) {
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public GrpcExporterBuilder<T> setConnectTimeout(long timeout, TimeUnit unit) {
        this.connectTimeoutNanos = timeout == 0L ? Long.MAX_VALUE : unit.toNanos(timeout);
        return this;
    }

    public GrpcExporterBuilder<T> setEndpoint(String endpoint) {
        this.endpoint = ExporterBuilderUtil.validateEndpoint(endpoint);
        return this;
    }

    public GrpcExporterBuilder<T> setCompression(@Nullable Compressor compressor) {
        this.compressor = compressor;
        return this;
    }

    public GrpcExporterBuilder<T> setCompression(String compressionMethod) {
        Compressor compressor = CompressorUtil.validateAndResolveCompressor(compressionMethod, this.componentLoader);
        return this.setCompression(compressor);
    }

    public GrpcExporterBuilder<T> setTrustManagerFromCerts(byte[] trustedCertificatesPem) {
        this.tlsConfigHelper.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public GrpcExporterBuilder<T> setKeyManagerFromCerts(byte[] privateKeyPem, byte[] certificatePem) {
        this.tlsConfigHelper.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public GrpcExporterBuilder<T> setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.tlsConfigHelper.setSslContext(sslContext, trustManager);
        return this;
    }

    public GrpcExporterBuilder<T> addConstantHeader(String key, String value) {
        this.constantHeaders.put(key, value);
        return this;
    }

    public GrpcExporterBuilder<T> setHeadersSupplier(Supplier<Map<String, String>> headerSupplier) {
        this.headerSupplier = headerSupplier;
        return this;
    }

    public GrpcExporterBuilder<T> setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public GrpcExporterBuilder<T> setMeterProvider(Supplier<MeterProvider> meterProviderSupplier) {
        this.meterProviderSupplier = meterProviderSupplier;
        return this;
    }

    public GrpcExporterBuilder<T> setInternalTelemetryVersion(InternalTelemetryVersion internalTelemetryVersion) {
        this.internalTelemetryVersion = internalTelemetryVersion;
        return this;
    }

    public GrpcExporterBuilder<T> setComponentLoader(ComponentLoader componentLoader) {
        this.componentLoader = componentLoader;
        return this;
    }

    public GrpcExporterBuilder<T> setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public GrpcExporterBuilder<T> copy() {
        GrpcExporterBuilder<T> copy = new GrpcExporterBuilder<T>(this.exporterType, TimeUnit.NANOSECONDS.toSeconds(this.timeoutNanos), this.endpoint, this.grpcStubFactory, this.grpcEndpointPath);
        copy.timeoutNanos = this.timeoutNanos;
        copy.connectTimeoutNanos = this.connectTimeoutNanos;
        copy.endpoint = this.endpoint;
        copy.compressor = this.compressor;
        copy.constantHeaders.putAll(this.constantHeaders);
        copy.headerSupplier = this.headerSupplier;
        copy.tlsConfigHelper = this.tlsConfigHelper.copy();
        if (this.retryPolicy != null) {
            copy.retryPolicy = this.retryPolicy.toBuilder().build();
        }
        copy.meterProviderSupplier = this.meterProviderSupplier;
        copy.internalTelemetryVersion = this.internalTelemetryVersion;
        copy.grpcChannel = this.grpcChannel;
        copy.componentLoader = this.componentLoader;
        return copy;
    }

    public GrpcExporter<T> build() {
        Supplier<Map<String, List<String>>> headerSupplier = () -> {
            HashMap result = new HashMap();
            Map<String, String> supplierResult = this.headerSupplier.get();
            if (supplierResult != null) {
                supplierResult.forEach((key, value) -> result.put(key, Collections.singletonList(value)));
            }
            this.constantHeaders.forEach((key, value) -> result.merge(key, Collections.singletonList(value), (v1, v2) -> {
                ArrayList merged = new ArrayList(v1);
                merged.addAll(v2);
                return merged;
            }));
            return result;
        };
        boolean isPlainHttp = "http".equals(this.endpoint.getScheme());
        GrpcSenderProvider grpcSenderProvider = this.resolveGrpcSenderProvider();
        GrpcSender<T> grpcSender = grpcSenderProvider.createSender(GrpcSenderConfig.create(this.endpoint, this.grpcEndpointPath, this.compressor, this.timeoutNanos, this.connectTimeoutNanos, headerSupplier, this.grpcChannel, this.grpcStubFactory, this.retryPolicy, isPlainHttp ? null : this.tlsConfigHelper.getSslContext(), isPlainHttp ? null : this.tlsConfigHelper.getTrustManager(), this.executorService));
        LOGGER.log(Level.FINE, "Using GrpcSender: " + grpcSender.getClass().getName());
        return new GrpcExporter<T>(grpcSender, this.internalTelemetryVersion, ComponentId.generateLazy((StandardComponentId.ExporterType)this.exporterType), this.meterProviderSupplier, this.endpoint.toString());
    }

    public String toString(boolean includePrefixAndSuffix) {
        StringJoiner joiner = includePrefixAndSuffix ? new StringJoiner(", ", "GrpcExporterBuilder{", "}") : new StringJoiner(", ");
        joiner.add("endpoint=" + this.endpoint.toString());
        joiner.add("endpointPath=" + this.grpcEndpointPath);
        joiner.add("timeoutNanos=" + this.timeoutNanos);
        joiner.add("connectTimeoutNanos=" + this.connectTimeoutNanos);
        joiner.add("compressorEncoding=" + (String)Optional.ofNullable(this.compressor).map(Compressor::getEncoding).orElse(null));
        StringJoiner headersJoiner = new StringJoiner(", ", "Headers{", "}");
        this.constantHeaders.forEach((key, value) -> headersJoiner.add(key + "=OBFUSCATED"));
        Map<String, String> headers = this.headerSupplier.get();
        if (headers != null) {
            headers.forEach((key, value) -> headersJoiner.add(key + "=OBFUSCATED"));
        }
        joiner.add("headers=" + headersJoiner);
        if (this.retryPolicy != null) {
            joiner.add("retryPolicy=" + this.retryPolicy);
        }
        if (this.grpcChannel != null) {
            joiner.add("grpcChannel=" + this.grpcChannel);
        }
        joiner.add("componentLoader=" + this.componentLoader);
        if (this.executorService != null) {
            joiner.add("executorService=" + this.executorService);
        }
        joiner.add("exporterType=" + this.exporterType.toString());
        joiner.add("internalTelemetrySchemaVersion=" + this.internalTelemetryVersion);
        return joiner.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    private GrpcSenderProvider resolveGrpcSenderProvider() {
        HashMap<String, GrpcSenderProvider> grpcSenderProviders = new HashMap<String, GrpcSenderProvider>();
        for (GrpcSenderProvider spi : this.componentLoader.load(GrpcSenderProvider.class)) {
            grpcSenderProviders.put(spi.getClass().getName(), spi);
        }
        if (grpcSenderProviders.isEmpty()) {
            throw new IllegalStateException("No GrpcSenderProvider found on classpath. Please add dependency on opentelemetry-exporter-sender-okhttp or opentelemetry-exporter-sender-grpc-managed-channel");
        }
        if (grpcSenderProviders.size() == 1) {
            return (GrpcSenderProvider)grpcSenderProviders.values().stream().findFirst().get();
        }
        String configuredSender = ConfigUtil.getString((String)"io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider", (String)"");
        if (configuredSender.isEmpty()) {
            LOGGER.log(Level.WARNING, "Multiple GrpcSenderProvider found. Please include only one, or specify preference setting io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider to the FQCN of the preferred provider.");
            return (GrpcSenderProvider)grpcSenderProviders.values().stream().findFirst().get();
        }
        if (grpcSenderProviders.containsKey(configuredSender)) {
            return (GrpcSenderProvider)grpcSenderProviders.get(configuredSender);
        }
        throw new IllegalStateException("No GrpcSenderProvider matched configured io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider: " + configuredSender);
    }
}

