/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.common;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.incubator.common.ExtendedAttributeType;
import io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.api.incubator.internal.InternalExtendedAttributeKeyImpl;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface ExtendedAttributeKey<T> {
    public String getKey();

    public ExtendedAttributeType getType();

    @Nullable
    default public AttributeKey<T> asAttributeKey() {
        return InternalExtendedAttributeKeyImpl.toAttributeKey(this);
    }

    public static <T> ExtendedAttributeKey<T> fromAttributeKey(AttributeKey<T> attributeKey) {
        return InternalExtendedAttributeKeyImpl.toExtendedAttributeKey(attributeKey);
    }

    public static ExtendedAttributeKey<String> stringKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.stringKey((String)key));
    }

    public static ExtendedAttributeKey<Boolean> booleanKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.booleanKey((String)key));
    }

    public static ExtendedAttributeKey<Long> longKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.longKey((String)key));
    }

    public static ExtendedAttributeKey<Double> doubleKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.doubleKey((String)key));
    }

    public static ExtendedAttributeKey<List<String>> stringArrayKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.stringArrayKey((String)key));
    }

    public static ExtendedAttributeKey<List<Boolean>> booleanArrayKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.booleanArrayKey((String)key));
    }

    public static ExtendedAttributeKey<List<Long>> longArrayKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.longArrayKey((String)key));
    }

    public static ExtendedAttributeKey<List<Double>> doubleArrayKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.doubleArrayKey((String)key));
    }

    public static ExtendedAttributeKey<ExtendedAttributes> extendedAttributesKey(String key) {
        return InternalExtendedAttributeKeyImpl.create(key, ExtendedAttributeType.EXTENDED_ATTRIBUTES);
    }
}

