/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.okhttp.v3_0;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientResendCount;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.okhttp.v3_0.internal.ConnectionErrorSpanInterceptor;
import io.opentelemetry.instrumentation.okhttp.v3_0.internal.OkHttpAttributesGetter;
import io.opentelemetry.instrumentation.okhttp.v3_0.internal.OkHttpInstrumenterFactory;
import io.opentelemetry.instrumentation.okhttp.v3_0.internal.TracingInterceptor;
import io.opentelemetry.javaagent.bootstrap.internal.CommonConfig;
import java.util.Collections;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class OkHttp3Singletons {
    private static final Instrumenter<Request, Response> INSTRUMENTER = OkHttpInstrumenterFactory.create((OpenTelemetry)GlobalOpenTelemetry.get(), builder -> builder.setCapturedRequestHeaders(CommonConfig.get().getClientRequestHeaders()).setCapturedResponseHeaders(CommonConfig.get().getClientResponseHeaders()).setKnownMethods(CommonConfig.get().getKnownHttpRequestMethods()), builder -> builder.setKnownMethods(CommonConfig.get().getKnownHttpRequestMethods()), Collections.singletonList(PeerServiceAttributesExtractor.create((ServerAttributesGetter)OkHttpAttributesGetter.INSTANCE, (Map)CommonConfig.get().getPeerServiceMapping())), (boolean)CommonConfig.get().shouldEmitExperimentalHttpClientMetrics());
    public static final Interceptor CONTEXT_INTERCEPTOR = chain -> {
        try (Scope ignored = HttpClientResendCount.initialize((Context)Context.current()).makeCurrent();){
            Response response = chain.proceed(chain.request());
            return response;
        }
    };
    public static final Interceptor CONNECTION_ERROR_INTERCEPTOR = new ConnectionErrorSpanInterceptor(INSTRUMENTER);
    public static final Interceptor TRACING_INTERCEPTOR = new TracingInterceptor(INSTRUMENTER, GlobalOpenTelemetry.getPropagators());

    private OkHttp3Singletons() {
    }
}

