/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.okhttp.v3_0;

import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.okhttp.v3_0.OkHttp3Singletons;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import okhttp3.OkHttpClient;

public class OkHttp3Instrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"okhttp3.OkHttpClient$Builder");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isConstructor(), this.getClass().getName() + "$ConstructorAdvice");
    }

    public static class ConstructorAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void trackCallDepth(@Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            callDepth = CallDepth.forClass(OkHttpClient.Builder.class);
            callDepth.getAndIncrement();
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void addTracingInterceptor(@Advice.This OkHttpClient.Builder builder, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            if (callDepth.decrementAndGet() > 0) {
                return;
            }
            if (!builder.interceptors().contains(OkHttp3Singletons.CONTEXT_INTERCEPTOR)) {
                builder.interceptors().add(0, OkHttp3Singletons.CONTEXT_INTERCEPTOR);
                builder.interceptors().add(1, OkHttp3Singletons.CONNECTION_ERROR_INTERCEPTOR);
            }
            if (!builder.networkInterceptors().contains(OkHttp3Singletons.TRACING_INTERCEPTOR)) {
                builder.addNetworkInterceptor(OkHttp3Singletons.TRACING_INTERCEPTOR);
            }
        }
    }
}

