/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.okhttp.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.bootstrap.executors.ExecutorAdviceHelper;
import io.opentelemetry.javaagent.bootstrap.executors.PropagatedContext;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class OkHttp3DispatcherInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"okhttp3.Dispatcher");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"enqueue").or((ElementMatcher)ElementMatchers.named((String)"enqueue$okhttp")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)Runnable.class.getName())))), OkHttp3DispatcherInstrumentation.class.getName() + "$AttachStateAdvice");
    }

    public static class AttachStateAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static PropagatedContext onEnter(@Advice.Argument(value=0) Runnable call) {
            Context context = Java8BytecodeBridge.currentContext();
            if (ExecutorAdviceHelper.shouldPropagateContext((Context)context, (Object)call)) {
                VirtualField virtualField = VirtualField.find(Runnable.class, PropagatedContext.class);
                return ExecutorAdviceHelper.attachContextToTask((Context)context, (VirtualField)virtualField, (Object)call);
            }
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Enter PropagatedContext propagatedContext, @Advice.Thrown Throwable throwable) {
            ExecutorAdviceHelper.cleanUpAfterSubmit((PropagatedContext)propagatedContext, (Throwable)throwable);
        }
    }
}

