/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal;

import io.opentelemetry.instrumentation.spring.autoconfigure.internal.ConditionalOnEnabledInstrumentation;
import java.util.Map;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class InstrumentationPropertyEnabled
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnEnabledInstrumentation.class.getName());
        String name = String.format("otel.instrumentation.%s.enabled", attributes.get("module"));
        Boolean explicit = (Boolean)context.getEnvironment().getProperty(name, Boolean.class);
        if (explicit != null) {
            return explicit;
        }
        boolean defaultValue = (Boolean)attributes.get("enabledByDefault");
        if (!defaultValue) {
            return false;
        }
        return (Boolean)context.getEnvironment().getProperty("otel.instrumentation.common.default-enabled", Boolean.class, (Object)true);
    }
}

