/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.thread.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;

public class AddThreadDetailsSpanProcessor
implements SpanProcessor {
    public static final AttributeKey<Long> THREAD_ID = AttributeKey.longKey((String)"thread.id");
    public static final AttributeKey<String> THREAD_NAME = AttributeKey.stringKey((String)"thread.name");

    public void onStart(Context context, ReadWriteSpan span) {
        Thread currentThread = Thread.currentThread();
        span.setAttribute(THREAD_ID, (Object)currentThread.getId());
        span.setAttribute(THREAD_NAME, (Object)currentThread.getName());
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan span) {
    }

    public boolean isEndRequired() {
        return false;
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }
}

