/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.rxjava.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.reactivex.Observer;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.observers.BasicFuseableObserver;
import java.lang.reflect.Field;

class TracingObserver<T>
extends BasicFuseableObserver<T, T> {
    private static final Field queueDisposableField = TracingObserver.getQueueDisposableField();
    private final Observer<? super T> wrappedObserver;
    private final Context context;

    TracingObserver(Observer<? super T> actual, Context context) {
        super(actual);
        this.wrappedObserver = actual;
        this.context = context;
    }

    public void onNext(T t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.wrappedObserver.onNext(t);
        }
    }

    public void onError(Throwable t) {
        try (Scope ignored = this.context.makeCurrent();){
            this.wrappedObserver.onError(t);
        }
    }

    public void onComplete() {
        try (Scope ignored = this.context.makeCurrent();){
            this.wrappedObserver.onComplete();
        }
    }

    public int requestFusion(int mode) {
        QueueDisposable<T> qd = this.getQueueDisposable();
        if (qd != null) {
            int m;
            this.sourceMode = m = qd.requestFusion(mode);
            return m;
        }
        return 0;
    }

    public T poll() throws Exception {
        return (T)this.getQueueDisposable().poll();
    }

    private QueueDisposable<T> getQueueDisposable() {
        try {
            return (QueueDisposable)queueDisposableField.get((Object)this);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    private static Field getField(String fieldName) {
        try {
            return BasicFuseableObserver.class.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static Field getQueueDisposableField() {
        Field queueDisposableField = TracingObserver.getField("qd");
        if (queueDisposableField == null) {
            queueDisposableField = TracingObserver.getField("qs");
        }
        return queueDisposableField;
    }

    public static boolean canEnable() {
        return queueDisposableField != null;
    }
}

