/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.log4j.appender.v2_17;

import io.opentelemetry.api.logs.GlobalLoggerProvider;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.instrumentation.log4j.appender.v2_17.internal.ContextDataAccessor;
import io.opentelemetry.instrumentation.log4j.appender.v2_17.internal.LogEventMapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="OpenTelemetry", category="Core", elementType="appender")
public class OpenTelemetryAppender
extends AbstractAppender {
    static final String PLUGIN_NAME = "OpenTelemetry";
    private final LogEventMapper<ReadOnlyStringMap> mapper;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B builder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private OpenTelemetryAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, Property[] properties, boolean captureExperimentalAttributes, boolean captureMapMessageAttributes, boolean captureMarkerAttribute, String captureContextDataAttributes) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.mapper = new LogEventMapper<ReadOnlyStringMap>(ContextDataAccessorImpl.INSTANCE, captureExperimentalAttributes, captureMapMessageAttributes, captureMarkerAttribute, OpenTelemetryAppender.splitAndFilterBlanksAndNulls(captureContextDataAttributes));
    }

    private static List<String> splitAndFilterBlanksAndNulls(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public void append(LogEvent event) {
        String instrumentationName = event.getLoggerName();
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            instrumentationName = "ROOT";
        }
        LogRecordBuilder builder = GlobalLoggerProvider.get().loggerBuilder(instrumentationName).build().logRecordBuilder();
        ReadOnlyStringMap contextData = event.getContextData();
        this.mapper.mapLogEvent(builder, event.getMessage(), event.getLevel(), event.getMarker(), event.getThrown(), contextData);
        Instant timestamp = event.getInstant();
        if (timestamp != null) {
            builder.setEpoch(TimeUnit.MILLISECONDS.toNanos(timestamp.getEpochMillisecond()) + (long)timestamp.getNanoOfMillisecond(), TimeUnit.NANOSECONDS);
        }
        builder.emit();
    }

    static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<OpenTelemetryAppender> {
        @PluginBuilderAttribute
        private boolean captureExperimentalAttributes;
        @PluginBuilderAttribute
        private boolean captureMapMessageAttributes;
        @PluginBuilderAttribute
        private boolean captureMarkerAttribute;
        @PluginBuilderAttribute
        private String captureContextDataAttributes;

        Builder() {
        }

        public B setCaptureExperimentalAttributes(boolean captureExperimentalAttributes) {
            this.captureExperimentalAttributes = captureExperimentalAttributes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCaptureMapMessageAttributes(boolean captureMapMessageAttributes) {
            this.captureMapMessageAttributes = captureMapMessageAttributes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCaptureMarkerAttribute(boolean captureMarkerAttribute) {
            this.captureMarkerAttribute = captureMarkerAttribute;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCaptureContextDataAttributes(String captureContextDataAttributes) {
            this.captureContextDataAttributes = captureContextDataAttributes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public OpenTelemetryAppender build() {
            return new OpenTelemetryAppender(this.getName(), this.getLayout(), this.getFilter(), this.isIgnoreExceptions(), this.getPropertyArray(), this.captureExperimentalAttributes, this.captureMapMessageAttributes, this.captureMarkerAttribute, this.captureContextDataAttributes);
        }
    }

    private static enum ContextDataAccessorImpl implements ContextDataAccessor<ReadOnlyStringMap>
    {
        INSTANCE;


        @Override
        @Nullable
        public Object getValue(ReadOnlyStringMap contextData, String key) {
            return contextData.getValue(key);
        }

        @Override
        public void forEach(ReadOnlyStringMap contextData, BiConsumer<String, Object> action) {
            contextData.forEach(action::accept);
        }
    }
}

