/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.hikaricp.v3_0;

import com.zaxxer.hikari.metrics.IMetricsTracker;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import java.util.concurrent.TimeUnit;

final class OpenTelemetryMetricsTracker
implements IMetricsTracker {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final IMetricsTracker userMetricsTracker;
    private final BatchCallback callback;
    private final LongCounter timeouts;
    private final DoubleHistogram createTime;
    private final DoubleHistogram waitTime;
    private final DoubleHistogram useTime;
    private final Attributes attributes;

    OpenTelemetryMetricsTracker(IMetricsTracker userMetricsTracker, BatchCallback callback, LongCounter timeouts, DoubleHistogram createTime, DoubleHistogram waitTime, DoubleHistogram useTime, Attributes attributes) {
        this.userMetricsTracker = userMetricsTracker;
        this.callback = callback;
        this.timeouts = timeouts;
        this.createTime = createTime;
        this.waitTime = waitTime;
        this.useTime = useTime;
        this.attributes = attributes;
    }

    public void recordConnectionCreatedMillis(long connectionCreatedMillis) {
        this.createTime.record((double)connectionCreatedMillis, this.attributes);
        this.userMetricsTracker.recordConnectionCreatedMillis(connectionCreatedMillis);
    }

    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        double millis = (double)elapsedAcquiredNanos / NANOS_PER_MS;
        this.waitTime.record(millis, this.attributes);
        this.userMetricsTracker.recordConnectionAcquiredNanos(elapsedAcquiredNanos);
    }

    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.useTime.record((double)elapsedBorrowedMillis, this.attributes);
        this.userMetricsTracker.recordConnectionUsageMillis(elapsedBorrowedMillis);
    }

    public void recordConnectionTimeout() {
        this.timeouts.add(1L, this.attributes);
        this.userMetricsTracker.recordConnectionTimeout();
    }

    public void close() {
        this.callback.close();
        this.userMetricsTracker.close();
    }
}

