/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.guava.v10_0;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategy;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndSupport;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.guava.v10_0.GuavaAsyncOperationEndStrategyBuilder;

public final class GuavaAsyncOperationEndStrategy
implements AsyncOperationEndStrategy {
    static final AttributeKey<Boolean> CANCELED_ATTRIBUTE_KEY = AttributeKey.booleanKey((String)"guava.canceled");
    private final boolean captureExperimentalSpanAttributes;

    public static GuavaAsyncOperationEndStrategy create() {
        return GuavaAsyncOperationEndStrategy.builder().build();
    }

    public static GuavaAsyncOperationEndStrategyBuilder builder() {
        return new GuavaAsyncOperationEndStrategyBuilder();
    }

    GuavaAsyncOperationEndStrategy(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    public boolean supports(Class<?> returnType) {
        return ListenableFuture.class.isAssignableFrom(returnType);
    }

    public <REQUEST, RESPONSE> Object end(Instrumenter<REQUEST, RESPONSE> instrumenter, Context context, REQUEST request, Object asyncValue, Class<RESPONSE> responseType) {
        ListenableFuture future = (ListenableFuture)asyncValue;
        this.end(instrumenter, context, request, future, responseType);
        return future;
    }

    private <REQUEST, RESPONSE> void end(Instrumenter<REQUEST, RESPONSE> instrumenter, Context context, REQUEST request, ListenableFuture<?> future, Class<RESPONSE> responseType) {
        if (future.isDone()) {
            if (future.isCancelled()) {
                if (this.captureExperimentalSpanAttributes) {
                    Span.fromContext((Context)context).setAttribute(CANCELED_ATTRIBUTE_KEY, (Object)true);
                }
                instrumenter.end(context, request, null, null);
            } else {
                try {
                    Object response = Uninterruptibles.getUninterruptibly(future);
                    instrumenter.end(context, request, AsyncOperationEndSupport.tryToGetResponse(responseType, (Object)response), null);
                }
                catch (Throwable exception) {
                    instrumenter.end(context, request, null, exception);
                }
            }
        } else {
            future.addListener(() -> this.end(instrumenter, context, request, future, responseType), Runnable::run);
        }
    }
}

