/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.http.HttpResponse;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpRequestBase;

class AwsSdkHttpAttributesGetter
implements HttpClientAttributesGetter<Request<?>, Response<?>> {
    AwsSdkHttpAttributesGetter() {
    }

    public String getUrlFull(Request<?> request) {
        return request.getEndpoint().toString();
    }

    public String getHttpRequestMethod(Request<?> request) {
        return request.getHttpMethod().name();
    }

    public List<String> getHttpRequestHeader(Request<?> request, String name) {
        String value = (String)request.getHeaders().get(name.equals("user-agent") ? "User-Agent" : name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    public Integer getHttpResponseStatusCode(Request<?> request, Response<?> response, @Nullable Throwable error) {
        return response.getHttpResponse().getStatusCode();
    }

    public List<String> getHttpResponseHeader(Request<?> request, Response<?> response, String name) {
        String value = (String)response.getHttpResponse().getHeaders().get(name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @Nullable
    public String getNetworkProtocolName(Request<?> request, @Nullable Response<?> response) {
        ProtocolVersion protocolVersion = AwsSdkHttpAttributesGetter.getProtocolVersion(response);
        if (protocolVersion == null) {
            return null;
        }
        return protocolVersion.getProtocol();
    }

    @Nullable
    public String getNetworkProtocolVersion(Request<?> request, @Nullable Response<?> response) {
        ProtocolVersion protocolVersion = AwsSdkHttpAttributesGetter.getProtocolVersion(response);
        if (protocolVersion == null) {
            return null;
        }
        if (protocolVersion.getMinor() == 0) {
            return Integer.toString(protocolVersion.getMajor());
        }
        return protocolVersion.getMajor() + "." + protocolVersion.getMinor();
    }

    @Nullable
    private static ProtocolVersion getProtocolVersion(@Nullable Response<?> response) {
        if (response == null) {
            return null;
        }
        HttpResponse httpResponse = response.getHttpResponse();
        if (httpResponse == null) {
            return null;
        }
        HttpRequestBase httpRequest = httpResponse.getHttpRequest();
        if (httpRequest == null) {
            return null;
        }
        return httpRequest.getProtocolVersion();
    }

    @Nullable
    public String getServerAddress(Request<?> request) {
        return request.getEndpoint().getHost();
    }

    public Integer getServerPort(Request<?> request) {
        return request.getEndpoint().getPort();
    }
}

