/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdaevents.v2_2.internal;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

class SqsMessageSpanLinksExtractor
implements SpanLinksExtractor<SQSEvent.SQSMessage> {
    private static final String AWS_TRACE_HEADER_SQS_ATTRIBUTE_KEY = "AWSTraceHeader";
    static final String AWS_TRACE_HEADER_PROPAGATOR_KEY = "x-amzn-trace-id";

    SqsMessageSpanLinksExtractor() {
    }

    public void extract(SpanLinksBuilder spanLinks, Context parentContext, SQSEvent.SQSMessage message) {
        Context xrayContext;
        SpanContext messageSpanCtx;
        String parentHeader = (String)message.getAttributes().get(AWS_TRACE_HEADER_SQS_ATTRIBUTE_KEY);
        if (parentHeader != null && (messageSpanCtx = Span.fromContext((Context)(xrayContext = AwsXrayPropagator.getInstance().extract(Context.root(), Collections.singletonMap(AWS_TRACE_HEADER_PROPAGATOR_KEY, parentHeader), (TextMapGetter)MapGetter.INSTANCE))).getSpanContext()).isValid()) {
            spanLinks.addLink(messageSpanCtx);
        }
    }

    private static enum MapGetter implements TextMapGetter<Map<String, String>>
    {
        INSTANCE;


        public Iterable<String> keys(Map<String, String> map) {
            return map.keySet();
        }

        public String get(Map<String, String> map, String s) {
            return map.get(s.toLowerCase(Locale.ROOT));
        }
    }
}

