/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdaevents.v2_2.internal;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.AwsLambdaRequest;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.AwsLambdaFunctionAttributesExtractor;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.AwsLambdaFunctionInstrumenter;
import io.opentelemetry.instrumentation.awslambdaevents.v2_2.internal.ApiGatewayProxyAttributesExtractor;
import java.util.Set;

public final class AwsLambdaEventsInstrumenterFactory {
    public static AwsLambdaFunctionInstrumenter createInstrumenter(OpenTelemetry openTelemetry, Set<String> knownMethods) {
        return new AwsLambdaFunctionInstrumenter(openTelemetry, Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.opentelemetry.aws-lambda-events-2.2", AwsLambdaEventsInstrumenterFactory::spanName).addAttributesExtractor((AttributesExtractor)new AwsLambdaFunctionAttributesExtractor()).addAttributesExtractor((AttributesExtractor)new ApiGatewayProxyAttributesExtractor(knownMethods)).buildInstrumenter(SpanKindExtractor.alwaysServer()));
    }

    private static String spanName(AwsLambdaRequest input) {
        if (input.getInput() instanceof APIGatewayProxyRequestEvent) {
            APIGatewayProxyRequestEvent request = (APIGatewayProxyRequestEvent)input.getInput();
            String method = request.getHttpMethod();
            String route = request.getResource();
            if (method != null && route != null) {
                return method + " " + route;
            }
        }
        return input.getAwsContext().getFunctionName();
    }

    private AwsLambdaEventsInstrumenterFactory() {
    }
}

