/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdaevents.v2_2.internal;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.internal.HttpAttributes;
import io.opentelemetry.instrumentation.api.instrumenter.url.internal.UrlAttributes;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.AwsLambdaRequest;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.MapUtils;
import io.opentelemetry.semconv.SemanticAttributes;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class ApiGatewayProxyAttributesExtractor
implements AttributesExtractor<AwsLambdaRequest, Object> {
    private final Set<String> knownMethods;

    ApiGatewayProxyAttributesExtractor(Set<String> knownMethods) {
        this.knownMethods = knownMethods;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, AwsLambdaRequest request) {
        if (request.getInput() instanceof APIGatewayProxyRequestEvent) {
            attributes.put(SemanticAttributes.FAAS_TRIGGER, (Object)"http");
            this.onRequest(attributes, (APIGatewayProxyRequestEvent)request.getInput());
        }
    }

    void onRequest(AttributesBuilder attributes, APIGatewayProxyRequestEvent request) {
        String httpUrl;
        Map headers;
        String userAgent;
        String method = request.getHttpMethod();
        if (SemconvStability.emitStableHttpSemconv()) {
            if (method == null || this.knownMethods.contains(method)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)HttpAttributes.HTTP_REQUEST_METHOD, (Object)method);
            } else {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)HttpAttributes.HTTP_REQUEST_METHOD, (Object)"_OTHER");
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)HttpAttributes.HTTP_REQUEST_METHOD_ORIGINAL, (Object)method);
            }
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_METHOD, (Object)method);
        }
        if ((userAgent = (String)(headers = MapUtils.lowercaseMap((Map)request.getHeaders())).get("user-agent")) != null) {
            attributes.put(SemanticAttributes.USER_AGENT_ORIGINAL, (Object)userAgent);
        }
        if ((httpUrl = ApiGatewayProxyAttributesExtractor.getHttpUrl(request, headers)) != null) {
            if (SemconvStability.emitStableHttpSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)UrlAttributes.URL_FULL, (Object)httpUrl);
            }
            if (SemconvStability.emitOldHttpSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_URL, (Object)httpUrl);
            }
        }
    }

    private static String getHttpUrl(APIGatewayProxyRequestEvent request, Map<String, String> headers) {
        String path;
        String host;
        StringBuilder str = new StringBuilder();
        String scheme = headers.get("x-forwarded-proto");
        if (scheme != null) {
            str.append(scheme).append("://");
        }
        if ((host = headers.get("host")) != null) {
            str.append(host);
        }
        if ((path = request.getPath()) != null) {
            str.append(path);
        }
        try {
            boolean first = true;
            for (Map.Entry entry : MapUtils.emptyIfNull((Map)request.getQueryStringParameters()).entrySet()) {
                String key = URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8.name());
                String value = URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.name());
                str.append(first ? (char)'?' : '&').append(key).append('=').append(value);
                first = false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str.length() == 0 ? null : str.toString();
    }

    public void onEnd(AttributesBuilder attributes, Context context, AwsLambdaRequest request, @Nullable Object response, @Nullable Throwable error) {
        Integer statusCode;
        if (response instanceof APIGatewayProxyResponseEvent && (statusCode = ((APIGatewayProxyResponseEvent)response).getStatusCode()) != null) {
            if (SemconvStability.emitStableHttpSemconv()) {
                attributes.put(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, statusCode.intValue());
            }
            if (SemconvStability.emitOldHttpSemconv()) {
                attributes.put(SemanticAttributes.HTTP_STATUS_CODE, statusCode.intValue());
            }
        }
    }
}

