/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdaevents.v2_2;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.TracingRequestHandler;
import io.opentelemetry.instrumentation.awslambdaevents.v2_2.internal.AwsLambdaSqsInstrumenterFactory;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.time.Duration;

public abstract class TracingSqsEventHandler
extends TracingRequestHandler<SQSEvent, Void> {
    private final Instrumenter<SQSEvent, Void> instrumenter;

    protected TracingSqsEventHandler(OpenTelemetrySdk openTelemetrySdk) {
        this(openTelemetrySdk, DEFAULT_FLUSH_TIMEOUT);
    }

    protected TracingSqsEventHandler(OpenTelemetrySdk openTelemetrySdk, Duration flushTimeout) {
        this(openTelemetrySdk, flushTimeout, AwsLambdaSqsInstrumenterFactory.forEvent((OpenTelemetry)openTelemetrySdk));
    }

    protected TracingSqsEventHandler(OpenTelemetrySdk openTelemetrySdk, Duration flushTimeout, Instrumenter<SQSEvent, Void> instrumenter) {
        super(openTelemetrySdk, flushTimeout);
        this.instrumenter = instrumenter;
    }

    public Void doHandleRequest(SQSEvent event, com.amazonaws.services.lambda.runtime.Context context) {
        block12: {
            Context parentContext = Context.current();
            if (this.instrumenter.shouldStart(parentContext, (Object)event)) {
                Context otelContext = this.instrumenter.start(parentContext, (Object)event);
                Throwable error = null;
                try (Scope ignored = otelContext.makeCurrent();){
                    this.handleEvent(event, context);
                    break block12;
                }
                catch (Throwable t) {
                    error = t;
                    throw t;
                }
                finally {
                    this.instrumenter.end(otelContext, (Object)event, null, error);
                }
            }
            this.handleEvent(event, context);
        }
        return null;
    }

    protected abstract void handleEvent(SQSEvent var1, com.amazonaws.services.lambda.runtime.Context var2);
}

