/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdaevents.v2_2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

class CustomJodaModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public CustomJodaModule() {
        this.addDeserializer(DateTime.class, new DateTimeDeserialiser());
    }

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(@Nullable Object o) {
        return this == o;
    }

    private static class DateTimeDeserialiser
    extends JsonDeserializer<DateTime> {
        private final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");

        private DateTimeDeserialiser() {
        }

        public DateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.getCurrentTokenId() != 6) {
                throw new IllegalArgumentException("Only stream input is accepted");
            }
            String value = p.getText().trim();
            return value.isEmpty() ? null : this.dateFormatter.parseDateTime(value);
        }
    }
}

