/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.sql;

import io.openlineage.sql.SqlMeta;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.SystemUtils;

public final class OpenLineageSql {
    public static Optional<String> loadError = Optional.empty();

    private static native SqlMeta parse(List<String> var0, String var1, String var2) throws RuntimeException;

    public static Optional<SqlMeta> parse(List<String> sql, String dialect) {
        if (loadError.isPresent()) {
            return Optional.empty();
        }
        try {
            return Optional.of(OpenLineageSql.parse(sql, dialect, null));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    public static Optional<SqlMeta> parse(List<String> sql) {
        if (loadError.isPresent()) {
            return Optional.empty();
        }
        try {
            SqlMeta x = OpenLineageSql.parse(sql, null, null);
            return Optional.ofNullable(x);
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    public static native String provider();

    private static void loadNativeLibrary(String libName) throws IOException {
        String fullName = "io/openlineage/sql/" + libName;
        URL url = OpenLineageSql.class.getResource("/" + fullName);
        if (url == null) {
            throw new IOException("Library not found in resources.");
        }
        File tmpDir = Files.createTempDirectory("native-lib", new FileAttribute[0]).toFile();
        tmpDir.deleteOnExit();
        File nativeLib = new File(tmpDir, libName);
        nativeLib.deleteOnExit();
        try (InputStream in = url.openStream();){
            Files.copy(in, nativeLib.toPath(), new CopyOption[0]);
        }
        System.load(nativeLib.getAbsolutePath());
    }

    static {
        String libName = "libopenlineage_sql_java";
        if (SystemUtils.IS_OS_MAC_OSX && SystemUtils.OS_ARCH.equals("aarch64")) {
            libName = libName + "_arm64.dylib";
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            libName = libName + ".dylib";
        } else if (SystemUtils.IS_OS_LINUX && SystemUtils.OS_ARCH.equals("aarch64")) {
            libName = libName + "_aarch64.so";
        } else if (SystemUtils.IS_OS_LINUX && SystemUtils.OS_ARCH.equals("amd64")) {
            libName = libName + "_x86_64.so";
        } else {
            loadError = Optional.of("Cannot link native library: unsupported OS");
        }
        try {
            OpenLineageSql.loadNativeLibrary(libName);
        }
        catch (IOException e) {
            loadError = Optional.of(String.format("Error extracting native library '%s': %s", libName, e.getMessage()));
        }
    }
}

