/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark33.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.api.AbstractQueryPlanOutputDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.utils.DatasetVersionDatasetFacetUtils;
import io.openlineage.spark3.agent.utils.PlanUtils3;
import java.util.Collections;
import java.util.List;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceIcebergData;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceIcebergDataDatasetBuilder
extends AbstractQueryPlanOutputDatasetBuilder<LogicalPlan> {
    private static final Logger log = LoggerFactory.getLogger(ReplaceIcebergDataDatasetBuilder.class);

    public ReplaceIcebergDataDatasetBuilder(OpenLineageContext context) {
        super(context, false);
    }

    public static boolean hasClasses() {
        try {
            ReplaceIcebergDataDatasetBuilder.class.getClassLoader().loadClass("org.apache.spark.sql.catalyst.plans.logical.ReplaceIcebergData");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan x) {
        return x instanceof ReplaceIcebergData;
    }

    @Override
    public List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, LogicalPlan plan) {
        ReplaceIcebergData replace = (ReplaceIcebergData)plan;
        if (!(replace.table() instanceof DataSourceV2Relation)) {
            return Collections.emptyList();
        }
        DataSourceV2Relation table = (DataSourceV2Relation)replace.table();
        OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder = this.context.getOpenLineage().newDatasetFacetsBuilder();
        datasetFacetsBuilder.lifecycleStateChange(this.context.getOpenLineage().newLifecycleStateChangeDatasetFacet(OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE, null));
        if (this.includeDatasetVersion(event)) {
            DatasetVersionDatasetFacetUtils.includeDatasetVersion(this.context, datasetFacetsBuilder, table);
        }
        return PlanUtils3.fromDataSourceV2Relation(this.outputDataset(), this.context, table, datasetFacetsBuilder);
    }
}

