/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark33.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.AbstractQueryPlanOutputDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.CatalogUtils3;
import io.openlineage.spark3.agent.utils.PlanUtils3;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTable;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateReplaceDatasetBuilder
extends AbstractQueryPlanOutputDatasetBuilder<LogicalPlan> {
    private static final Logger log = LoggerFactory.getLogger(CreateReplaceDatasetBuilder.class);

    public CreateReplaceDatasetBuilder(OpenLineageContext context) {
        super(context, false);
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan x) {
        return x instanceof CreateTableAsSelect || x instanceof ReplaceTable || x instanceof ReplaceTableAsSelect || x instanceof CreateTable;
    }

    @Override
    protected List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, LogicalPlan plan) {
        if (plan instanceof CreateTableAsSelect) {
            return this.apply(event, (CreateTableAsSelect)plan);
        }
        if (plan instanceof ReplaceTableAsSelect) {
            return this.apply(event, (ReplaceTableAsSelect)plan);
        }
        if (plan instanceof CreateTable) {
            return this.apply(event, (CreateTable)plan);
        }
        return this.apply(event, (ReplaceTable)plan);
    }

    @Override
    protected List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, CreateTable plan) {
        return this.callCatalogMethod(plan.name()).map(catalogPlugin -> this.apply(event, (TableCatalog)catalogPlugin, ScalaConversionUtils.fromMap(plan.tableSpec().properties()), plan.tableName(), plan.tableSchema(), OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.CREATE)).orElse(Collections.emptyList());
    }

    @Override
    protected List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, CreateTableAsSelect plan) {
        return this.callCatalogMethod(plan.name()).map(catalogPlugin -> this.apply(event, (TableCatalog)catalogPlugin, ScalaConversionUtils.fromMap(plan.tableSpec().properties()), plan.tableName(), plan.tableSchema(), OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.CREATE)).orElse(Collections.emptyList());
    }

    @Override
    protected List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, ReplaceTable plan) {
        return this.callCatalogMethod(plan.name()).map(catalogPlugin -> this.apply(event, (TableCatalog)catalogPlugin, ScalaConversionUtils.fromMap(plan.tableSpec().properties()), plan.tableName(), plan.tableSchema(), OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE)).orElse(Collections.emptyList());
    }

    @Override
    protected List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, ReplaceTableAsSelect plan) {
        return this.callCatalogMethod(plan.name()).map(catalogPlugin -> this.apply(event, (TableCatalog)catalogPlugin, ScalaConversionUtils.fromMap(plan.tableSpec().properties()), plan.tableName(), plan.tableSchema(), OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE)).orElse(Collections.emptyList());
    }

    private Optional<TableCatalog> callCatalogMethod(LogicalPlan plan) {
        try {
            return Optional.of((TableCatalog)MethodUtils.invokeMethod((Object)plan, (String)"catalog", null));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Could not obtain catalog plugin", (Throwable)e);
            return Optional.empty();
        }
    }

    private List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, TableCatalog catalog, Map<String, String> tableProperties, Identifier identifier, StructType schema, OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange) {
        Optional<DatasetIdentifier> di = PlanUtils3.getDatasetIdentifier(this.context, catalog, identifier, tableProperties);
        if (!di.isPresent()) {
            return Collections.emptyList();
        }
        OpenLineage openLineage = this.context.getOpenLineage();
        OpenLineage.DatasetFacetsBuilder builder = openLineage.newDatasetFacetsBuilder().schema(PlanUtils.schemaFacet(openLineage, schema)).lifecycleStateChange(openLineage.newLifecycleStateChangeDatasetFacet(lifecycleStateChange, null)).dataSource(PlanUtils.datasourceFacet(openLineage, di.get().getNamespace()));
        if (this.includeDatasetVersion(event)) {
            Optional<String> datasetVersion = CatalogUtils3.getDatasetVersion(this.context, catalog, identifier, tableProperties);
            datasetVersion.ifPresent(version -> builder.version(openLineage.newDatasetVersionDatasetFacet((String)version)));
        }
        CatalogUtils3.getStorageDatasetFacet(this.context, catalog, tableProperties).map(storageDatasetFacet -> builder.storage((OpenLineage.StorageDatasetFacet)storageDatasetFacet));
        return Collections.singletonList(this.outputDataset().getDataset(di.get(), builder));
    }
}

