/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.utils;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.CatalogUtils3;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.UnsupportedCatalogException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.internal.SharedState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.IndexedSeq;

public class PlanUtils3 {
    private static final Logger log = LoggerFactory.getLogger(PlanUtils3.class);

    public static Optional<DatasetIdentifier> getDatasetIdentifier(OpenLineageContext context, DataSourceV2Relation relation) {
        if (relation.identifier() == null || relation.identifier().isEmpty()) {
            return PlanUtils3.getDatasetIdentifierFromRelation(relation);
        }
        return Optional.of(relation).filter(r -> r.identifier() != null).filter(r -> r.identifier().isDefined()).filter(r -> r.catalog() != null).filter(r -> r.catalog().isDefined()).filter(r -> r.catalog().get() instanceof TableCatalog).flatMap(r -> PlanUtils3.getDatasetIdentifier(context, (TableCatalog)r.catalog().get(), (Identifier)r.identifier().get(), r.table().properties()));
    }

    public static Optional<DatasetIdentifier> getDatasetIdentifier(OpenLineageContext context, TableCatalog catalog, Identifier identifier, Map<String, String> properties) {
        if (!context.getSparkSession().isPresent()) {
            throw new IllegalArgumentException("SparkSession cannot be empty");
        }
        try {
            return Optional.of(CatalogUtils3.getDatasetIdentifier(context, catalog, identifier, properties));
        }
        catch (UnsupportedCatalogException ex) {
            log.error(String.format("Catalog %s is unsupported", ex.getMessage()), (Throwable)ex);
            return Optional.empty();
        }
        catch (Exception e) {
            if (e instanceof NoSuchTableException) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private static Optional<DatasetIdentifier> getDatasetIdentifierFromRelation(DataSourceV2Relation relation) {
        try {
            return Optional.of(CatalogUtils3.getDatasetIdentifierFromRelation(relation));
        }
        catch (UnsupportedCatalogException ex) {
            log.error(String.format("Catalog %s is unsupported", ex.getMessage()), (Throwable)ex);
            return Optional.empty();
        }
    }

    public static <D extends OpenLineage.Dataset> List<D> fromDataSourceV2Relation(DatasetFactory<D> datasetFactory, OpenLineageContext context, DataSourceV2Relation relation) {
        return PlanUtils3.fromDataSourceV2Relation(datasetFactory, context, relation, context.getOpenLineage().newDatasetFacetsBuilder());
    }

    public static <D extends OpenLineage.Dataset> List<D> fromDataSourceV2Relation(DatasetFactory<D> datasetFactory, OpenLineageContext context, DataSourceV2Relation relation, OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder) {
        Optional<DatasetIdentifier> di;
        OpenLineage openLineage = context.getOpenLineage();
        if (relation.identifier().isEmpty()) {
            log.warn("Couldn't find identifier for dataset in plan {}", (Object)relation);
            di = PlanUtils3.getDatasetIdentifier(context, relation);
            if (!di.isPresent()) {
                return Collections.emptyList();
            }
        } else {
            Identifier identifier = (Identifier)relation.identifier().get();
            if (relation.catalog().isEmpty() || !(relation.catalog().get() instanceof TableCatalog)) {
                log.warn("Couldn't find catalog for dataset in plan " + relation);
                return Collections.emptyList();
            }
            TableCatalog tableCatalog = (TableCatalog)relation.catalog().get();
            Map tableProperties = relation.table().properties();
            di = PlanUtils3.getDatasetIdentifier(context, tableCatalog, identifier, tableProperties);
            CatalogUtils3.getStorageDatasetFacet(context, tableCatalog, tableProperties).map(storageDatasetFacet -> datasetFacetsBuilder.storage((OpenLineage.StorageDatasetFacet)storageDatasetFacet));
        }
        if (!di.isPresent()) {
            return Collections.emptyList();
        }
        datasetFacetsBuilder.schema(PlanUtils.schemaFacet(openLineage, relation.schema())).dataSource(PlanUtils.datasourceFacet(openLineage, di.get().getNamespace()));
        return Collections.singletonList(datasetFactory.getDataset(di.get(), datasetFacetsBuilder));
    }

    public static Optional<LogicalPlan> getLogicalPlanOf(OpenLineageContext context, InMemoryRelation inMemoryRelation) {
        try {
            SharedState sharedState = context.getSparkSession().get().sharedState();
            CacheManager cacheManager = (CacheManager)FieldUtils.getField(SharedState.class, (String)"cacheManager", (boolean)true).get(sharedState);
            IndexedSeq cachedDataIndexedSeq = (IndexedSeq)FieldUtils.getField(CacheManager.class, (String)"cachedData", (boolean)true).get(cacheManager);
            return ScalaConversionUtils.fromSeq(cachedDataIndexedSeq).stream().filter(cachedData -> cachedData.cachedRepresentation().cacheBuilder().cachedName().equals(inMemoryRelation.cacheBuilder().cachedName())).map(cachedData -> cachedData.plan()).findAny();
        }
        catch (Exception e) {
            log.warn("cannot extract logical plan", (Throwable)e);
            return Optional.empty();
        }
    }
}

