/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.utils;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.CatalogUtils3;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.delta.files.TahoeLogFileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetVersionDatasetFacetUtils {
    private static final Logger log = LoggerFactory.getLogger(DatasetVersionDatasetFacetUtils.class);
    private static final String DELTA = "delta";

    public static Optional<String> extractVersionFromDataSourceV2Relation(OpenLineageContext context, DataSourceV2Relation table) {
        if (table.identifier().isEmpty()) {
            log.warn("Couldn't find identifier for dataset in plan " + table);
            return Optional.empty();
        }
        Identifier identifier = (Identifier)table.identifier().get();
        if (table.catalog().isEmpty() || !(table.catalog().get() instanceof TableCatalog)) {
            log.warn("Couldn't find catalog for dataset in plan " + table);
            return Optional.empty();
        }
        TableCatalog tableCatalog = (TableCatalog)table.catalog().get();
        Map tableProperties = table.table().properties();
        return CatalogUtils3.getDatasetVersion(context, tableCatalog, identifier, tableProperties);
    }

    public static Optional<String> extractVersionFromLogicalRelation(LogicalRelation logicalRelation) {
        if (logicalRelation.relation() instanceof HadoopFsRelation) {
            HadoopFsRelation fsRelation = (HadoopFsRelation)logicalRelation.relation();
            ScalaConversionUtils.asJavaOptional(logicalRelation.catalogTable());
            if (logicalRelation.catalogTable().isDefined() && ((CatalogTable)logicalRelation.catalogTable().get()).provider().isDefined() && DELTA.equalsIgnoreCase((String)((CatalogTable)logicalRelation.catalogTable().get()).provider().get()) && DatasetVersionDatasetFacetUtils.hasDeltaClasses() && fsRelation.location() instanceof TahoeLogFileIndex) {
                TahoeLogFileIndex fileIndex = (TahoeLogFileIndex)fsRelation.location();
                return Optional.of(Long.toString(fileIndex.getSnapshot().version()));
            }
        }
        return Optional.empty();
    }

    protected static boolean hasDeltaClasses() {
        try {
            DatasetVersionDatasetFacetUtils.class.getClassLoader().loadClass("org.apache.spark.sql.delta.files.TahoeLogFileIndex");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void includeDatasetVersion(OpenLineageContext context, OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder, DataSourceV2Relation relation) {
        DatasetVersionDatasetFacetUtils.extractVersionFromDataSourceV2Relation(context, relation).ifPresent(version -> datasetFacetsBuilder.version(context.getOpenLineage().newDatasetVersionDatasetFacet((String)version)));
    }
}

