/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.column;

import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageBuilder;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.column.CustomCollectorsUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;

public class OutputFieldsCollector {
    public static void collect(OpenLineageContext context, LogicalPlan plan, ColumnLevelLineageBuilder builder) {
        OutputFieldsCollector.getOutputExpressionsFromRoot(plan).stream().forEach(expr -> builder.addOutput(expr.exprId(), expr.name()));
        CustomCollectorsUtils.collectOutputs(context, plan, builder);
        if (!builder.hasOutputs()) {
            ScalaConversionUtils.fromSeq(plan.children()).stream().forEach(childPlan -> OutputFieldsCollector.collect(context, childPlan, builder));
        }
    }

    static List<NamedExpression> getOutputExpressionsFromRoot(LogicalPlan plan) {
        List<NamedExpression> expressions = ScalaConversionUtils.fromSeq(plan.output()).stream().filter(attr -> attr instanceof Attribute).map(attr -> attr).collect(Collectors.toList());
        if (plan instanceof Aggregate) {
            expressions.addAll(ScalaConversionUtils.fromSeq(((Aggregate)plan).aggregateExpressions()));
        } else if (plan instanceof Project) {
            expressions.addAll(ScalaConversionUtils.fromSeq(((Project)plan).projectList()));
        }
        return expressions;
    }

    static List<NamedExpression> getOutputExpressionsFromTree(LogicalPlan plan) {
        List<NamedExpression> expressions = OutputFieldsCollector.getOutputExpressionsFromRoot(plan);
        if (expressions == null || expressions.isEmpty()) {
            ScalaConversionUtils.fromSeq(plan.children()).stream().forEach(childPlan -> expressions.addAll(OutputFieldsCollector.getOutputExpressionsFromTree(childPlan)));
        }
        return expressions;
    }
}

