/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.column;

import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageBuilder;
import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageVisitor;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.column.InputFieldsCollector;
import io.openlineage.spark3.agent.lifecycle.plan.column.OutputFieldsCollector;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeAction;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.commands.MergeIntoCommand;

public abstract class MergeIntoDeltaColumnLineageVisitor
implements ColumnLevelLineageVisitor {
    protected OpenLineageContext context;

    public MergeIntoDeltaColumnLineageVisitor(OpenLineageContext context) {
        this.context = context;
    }

    @Override
    public void collectInputs(LogicalPlan node, ColumnLevelLineageBuilder builder) {
        if (node instanceof MergeIntoCommand) {
            InputFieldsCollector.collect(this.context, ((MergeIntoCommand)node).target(), builder);
            List mergeActions = this.getMergeActions((MergeIntoCommand)node).collect(Collectors.toList());
            List mergeActionsExprIds = this.getMergeActions((MergeIntoCommand)node).filter(action -> action instanceof DeltaMergeAction).map(action -> (DeltaMergeAction)action).filter(action -> action.child() instanceof AttributeReference).filter(action -> builder.getOutputExprIdByFieldName(action.targetColNameParts().mkString()).isPresent()).map(action -> ((AttributeReference)action.child()).exprId()).collect(Collectors.toList());
            List<ExprId> inputsToRemove = builder.getInputs().keySet().stream().filter(id -> !mergeActionsExprIds.contains(id)).collect(Collectors.toList());
            inputsToRemove.forEach(id -> builder.getInputs().remove(id));
            InputFieldsCollector.collect(this.context, ((MergeIntoCommand)node).source(), builder);
        }
    }

    @Override
    public void collectOutputs(LogicalPlan node, ColumnLevelLineageBuilder builder) {
        if (node instanceof MergeIntoCommand) {
            OutputFieldsCollector.collect(this.context, ((MergeIntoCommand)node).target(), builder);
        }
    }

    public abstract Stream<Expression> getMergeActions(MergeIntoCommand var1);

    @Override
    public void collectExpressionDependencies(LogicalPlan node, ColumnLevelLineageBuilder builder) {
        if (node instanceof MergeIntoCommand) {
            this.getMergeActions((MergeIntoCommand)node).filter(action -> action instanceof DeltaMergeAction).map(action -> (DeltaMergeAction)action).filter(action -> action.child() instanceof AttributeReference).filter(action -> builder.getOutputExprIdByFieldName(action.targetColNameParts().mkString()).isPresent()).forEach(action -> builder.addDependency(builder.getOutputExprIdByFieldName(action.targetColNameParts().mkString()).get(), ((AttributeReference)action.child()).exprId()));
        }
    }

    private Stream<DeltaMergeAction> getMergeActionsAttributes(LogicalPlan node, ColumnLevelLineageBuilder builder) {
        return this.getMergeActions((MergeIntoCommand)node).filter(action -> action instanceof DeltaMergeAction).map(action -> (DeltaMergeAction)action).filter(action -> action.child() instanceof AttributeReference).filter(action -> builder.getOutputExprIdByFieldName(action.targetColNameParts().mkString()).isPresent());
    }
}

