/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.column;

import com.google.cloud.spark.bigquery.BigQueryRelation;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.lifecycle.Rdds;
import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageBuilder;
import io.openlineage.spark.agent.util.BigQueryUtils;
import io.openlineage.spark.agent.util.JdbcUtils;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.column.CustomCollectorsUtils;
import io.openlineage.spark3.agent.lifecycle.plan.column.JdbcColumnLineageCollector;
import io.openlineage.spark3.agent.utils.PlanUtils3;
import io.openlineage.sql.SqlMeta;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.UnaryNode;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class InputFieldsCollector {
    private static final Logger log = LoggerFactory.getLogger(InputFieldsCollector.class);

    public static void collect(OpenLineageContext context, LogicalPlan plan, ColumnLevelLineageBuilder builder) {
        InputFieldsCollector.discoverInputsFromNode(context, plan, builder);
        CustomCollectorsUtils.collectInputs(context, plan, builder);
        if (plan.getClass().isAssignableFrom(UnaryNode.class)) {
            InputFieldsCollector.collect(context, ((UnaryNode)plan).child(), builder);
        } else if (plan.children() != null) {
            ScalaConversionUtils.fromSeq(plan.children()).stream().forEach(child -> InputFieldsCollector.collect(context, child, builder));
        }
    }

    private static void discoverInputsFromNode(OpenLineageContext context, LogicalPlan node, ColumnLevelLineageBuilder builder) {
        List<DatasetIdentifier> datasetIdentifiers = InputFieldsCollector.extractDatasetIdentifier(context, node);
        if (InputFieldsCollector.isJDBCNode(node)) {
            JdbcColumnLineageCollector.extractExternalInputs(node, builder, datasetIdentifiers);
        } else {
            InputFieldsCollector.extreactInternalInputs(node, builder, datasetIdentifiers);
        }
    }

    private static boolean isJDBCNode(LogicalPlan node) {
        return node instanceof LogicalRelation && ((LogicalRelation)node).relation() instanceof JDBCRelation;
    }

    private static void extreactInternalInputs(LogicalPlan node, ColumnLevelLineageBuilder builder, List<DatasetIdentifier> datasetIdentifiers) {
        datasetIdentifiers.stream().forEach(di -> ScalaConversionUtils.fromSeq(node.output()).stream().filter(attr -> attr instanceof AttributeReference).map(attr -> (AttributeReference)attr).collect(Collectors.toList()).forEach(attr -> builder.addInput(attr.exprId(), (DatasetIdentifier)di, attr.name())));
    }

    private static List<DatasetIdentifier> extractDatasetIdentifier(OpenLineageContext context, LogicalPlan node) {
        if (node instanceof DataSourceV2Relation) {
            return InputFieldsCollector.extractDatasetIdentifier(context, (DataSourceV2Relation)node);
        }
        if (node instanceof DataSourceV2ScanRelation) {
            return InputFieldsCollector.extractDatasetIdentifier(context, ((DataSourceV2ScanRelation)node).relation());
        }
        if (node instanceof HiveTableRelation) {
            return InputFieldsCollector.extractDatasetIdentifier(((HiveTableRelation)node).tableMeta());
        }
        if (node instanceof LogicalRelation && ((LogicalRelation)node).catalogTable().isDefined()) {
            return InputFieldsCollector.extractDatasetIdentifier((CatalogTable)((LogicalRelation)node).catalogTable().get());
        }
        if (node instanceof LogicalRelation && ((LogicalRelation)node).relation() instanceof HadoopFsRelation) {
            HadoopFsRelation relation = (HadoopFsRelation)((LogicalRelation)node).relation();
            return InputFieldsCollector.extractDatasetIdentifier(relation);
        }
        if (node instanceof LogicalRelation && BigQueryUtils.hasBigQueryClasses() && ((LogicalRelation)node).relation() instanceof BigQueryRelation) {
            BigQueryRelation relation = (BigQueryRelation)((LogicalRelation)node).relation();
            return BigQueryUtils.extractDatasetIdentifier(relation);
        }
        if (node instanceof LogicalRelation && ((LogicalRelation)node).relation() instanceof JDBCRelation) {
            JDBCRelation relation = (JDBCRelation)((LogicalRelation)node).relation();
            return InputFieldsCollector.extractDatasetIdentifier(relation);
        }
        if (node instanceof LogicalRDD) {
            return InputFieldsCollector.extractDatasetIdentifier((LogicalRDD)node);
        }
        if (!(node instanceof InMemoryRelation) && !(node instanceof OneRowRelation) && !(node instanceof LocalRelation) && node instanceof LeafNode) {
            log.warn("Could not extract dataset identifier from {}", (Object)node.getClass().getCanonicalName());
        }
        return Collections.emptyList();
    }

    private static List<DatasetIdentifier> extractDatasetIdentifier(JDBCRelation relation) {
        Optional<SqlMeta> sqlMeta = JdbcUtils.extractQueryFromSpark(relation);
        return sqlMeta.map(meta -> meta.inTables().stream().map(e -> new DatasetIdentifier(e.name(), relation.jdbcOptions().url())).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static List<DatasetIdentifier> extractDatasetIdentifier(LogicalRDD logicalRDD) {
        List<RDD<?>> fileLikeRdds = Rdds.findFileLikeRdds(logicalRDD.rdd());
        return PlanUtils.findRDDPaths(fileLikeRdds).stream().map(path -> PathUtils.fromURI(path.toUri())).collect(Collectors.toList());
    }

    private static List<DatasetIdentifier> extractDatasetIdentifier(OpenLineageContext context, DataSourceV2Relation relation) {
        return PlanUtils3.getDatasetIdentifier(context, relation).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private static List<DatasetIdentifier> extractDatasetIdentifier(CatalogTable catalogTable) {
        URI location = catalogTable.location();
        if (location == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new DatasetIdentifier(catalogTable.location().getPath(), PlanUtils.namespaceUri(catalogTable.location())));
    }

    private static List<DatasetIdentifier> extractDatasetIdentifier(HadoopFsRelation relation) {
        ArrayList<DatasetIdentifier> inputDatasets = new ArrayList<DatasetIdentifier>();
        List paths = JavaConversions.asJavaCollection((Iterable)relation.location().rootPaths()).stream().collect(Collectors.toList());
        for (Path p : paths) {
            String namespace = PlanUtils.namespaceUri(p.toUri());
            inputDatasets.add(new DatasetIdentifier(p.toUri().getPath(), namespace));
        }
        return inputDatasets;
    }
}

