/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.column;

import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageBuilder;
import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageVisitor;
import io.openlineage.spark.agent.lifecycle.plan.column.CustomColumnLineageVisitor;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCollectorsUtils {
    private static final Logger log = LoggerFactory.getLogger(CustomCollectorsUtils.class);

    private static Stream<ColumnLevelLineageVisitor> loadCollectors(OpenLineageContext context) {
        ServiceLoader<CustomColumnLineageVisitor> loader = ServiceLoader.load(CustomColumnLineageVisitor.class);
        return Stream.concat(StreamSupport.stream(Spliterators.spliteratorUnknownSize(loader.iterator(), 0), false), context.getColumnLevelLineageVisitors().stream());
    }

    static void collectInputs(OpenLineageContext context, LogicalPlan plan, ColumnLevelLineageBuilder builder) {
        CustomCollectorsUtils.loadCollectors(context).forEach(collector -> collector.collectInputs(plan, builder));
    }

    static void collectOutputs(OpenLineageContext context, LogicalPlan plan, ColumnLevelLineageBuilder builder) {
        CustomCollectorsUtils.loadCollectors(context).forEach(collector -> collector.collectOutputs(plan, builder));
    }

    static void collectExpressionDependencies(OpenLineageContext context, LogicalPlan plan, ColumnLevelLineageBuilder builder) {
        CustomCollectorsUtils.loadCollectors(context).forEach(collector -> collector.collectExpressionDependencies(plan, builder));
    }
}

