/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import io.openlineage.spark3.agent.utils.PlanUtils3;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.apache.spark.sql.catalyst.analysis.ResolvedTable;
import org.apache.spark.sql.catalyst.plans.logical.DropTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableVisitor
extends QueryPlanVisitor<DropTable, OpenLineage.OutputDataset> {
    private static final Logger log = LoggerFactory.getLogger(DropTableVisitor.class);

    public DropTableVisitor(@NonNull OpenLineageContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        ResolvedTable resolvedTable = (ResolvedTable)((DropTable)x).child();
        TableCatalog tableCatalog = resolvedTable.catalog();
        Map tableProperties = resolvedTable.table().properties();
        Identifier identifier = resolvedTable.identifier();
        Optional<DatasetIdentifier> di = PlanUtils3.getDatasetIdentifier(this.context, tableCatalog, identifier, tableProperties);
        if (di.isPresent()) {
            return Collections.singletonList(this.outputDataset().getDataset(di.get(), resolvedTable.schema(), OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.DROP));
        }
        return Collections.emptyList();
    }
}

