/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.api.AbstractQueryPlanOutputDatasetBuilder;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.utils.DatasetVersionDatasetFacetUtils;
import io.openlineage.spark3.agent.utils.PlanUtils3;
import java.util.List;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceV2RelationOutputDatasetBuilder
extends AbstractQueryPlanOutputDatasetBuilder<DataSourceV2Relation> {
    private static final Logger log = LoggerFactory.getLogger(DataSourceV2RelationOutputDatasetBuilder.class);
    private final DatasetFactory<OpenLineage.OutputDataset> factory;

    public DataSourceV2RelationOutputDatasetBuilder(OpenLineageContext context, DatasetFactory<OpenLineage.OutputDataset> factory) {
        super(context, false);
        this.factory = factory;
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan logicalPlan) {
        return logicalPlan instanceof DataSourceV2Relation;
    }

    @Override
    protected List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, DataSourceV2Relation relation) {
        OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder = this.context.getOpenLineage().newDatasetFacetsBuilder();
        if (this.includeDatasetVersion(event)) {
            DatasetVersionDatasetFacetUtils.includeDatasetVersion(this.context, datasetFacetsBuilder, relation);
        }
        return PlanUtils3.fromDataSourceV2Relation(this.factory, this.context, relation, datasetFacetsBuilder);
    }
}

