/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.CreateTableLikeCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableLikeCommandVisitor
extends QueryPlanVisitor<CreateTableLikeCommand, OpenLineage.OutputDataset> {
    private static final Logger log = LoggerFactory.getLogger(CreateTableLikeCommandVisitor.class);

    public CreateTableLikeCommandVisitor(OpenLineageContext context) {
        super(context);
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        CreateTableLikeCommand command = (CreateTableLikeCommand)x;
        return this.context.getSparkSession().map(session -> {
            SessionCatalog catalog = session.sessionState().catalog();
            CatalogTable source = catalog.getTempViewOrPermanentTableMetadata(command.sourceTable());
            URI defaultLocation = catalog.defaultTablePath(command.targetTable());
            URI location = ScalaConversionUtils.asJavaOptional(command.fileFormat().locationUri()).orElse(defaultLocation);
            DatasetIdentifier di = PathUtils.fromURI(location, "file");
            return Collections.singletonList(this.outputDataset().getDataset(di, source.schema(), OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.CREATE));
        }).orElse(Collections.emptyList());
    }
}

