/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.AbstractQueryPlanOutputDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.CatalogUtils3;
import io.openlineage.spark3.agent.utils.PlanUtils3;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateV2Table;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTable;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateReplaceDatasetBuilder
extends AbstractQueryPlanOutputDatasetBuilder<LogicalPlan> {
    private static final Logger log = LoggerFactory.getLogger(CreateReplaceDatasetBuilder.class);
    private static final String CREATE_V2_TABLE = "org.apache.spark.sql.catalyst.plans.logical.CreateV2Table";

    public CreateReplaceDatasetBuilder(OpenLineageContext context) {
        super(context, false);
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan x) {
        return x instanceof CreateTableAsSelect || x instanceof ReplaceTable || x instanceof ReplaceTableAsSelect || PlanUtils.safeIsInstanceOf(x, CREATE_V2_TABLE);
    }

    @Override
    protected List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, LogicalPlan x) {
        OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange;
        StructType schema;
        Identifier identifier;
        Map<String, String> tableProperties;
        TableCatalog tableCatalog;
        CreateTableAsSelect command;
        if (x instanceof CreateTableAsSelect) {
            command = (CreateTableAsSelect)x;
            tableCatalog = command.catalog();
            tableProperties = ScalaConversionUtils.fromMap(command.properties());
            identifier = command.tableName();
            schema = command.tableSchema();
            lifecycleStateChange = OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.CREATE;
        } else if (PlanUtils.safeIsInstanceOf(x, CREATE_V2_TABLE)) {
            command = (CreateV2Table)x;
            tableCatalog = command.catalog();
            tableProperties = ScalaConversionUtils.fromMap(command.properties());
            identifier = command.tableName();
            schema = command.tableSchema();
            lifecycleStateChange = OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.CREATE;
        } else if (x instanceof ReplaceTable) {
            command = (ReplaceTable)x;
            tableCatalog = command.catalog();
            tableProperties = ScalaConversionUtils.fromMap(command.properties());
            identifier = command.tableName();
            schema = command.tableSchema();
            lifecycleStateChange = OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE;
        } else {
            command = (ReplaceTableAsSelect)x;
            tableCatalog = command.catalog();
            tableProperties = ScalaConversionUtils.fromMap(command.properties());
            identifier = command.tableName();
            schema = command.tableSchema();
            lifecycleStateChange = OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE;
        }
        Optional<DatasetIdentifier> di = PlanUtils3.getDatasetIdentifier(this.context, tableCatalog, identifier, tableProperties);
        if (!di.isPresent()) {
            return Collections.emptyList();
        }
        OpenLineage openLineage = this.context.getOpenLineage();
        OpenLineage.DatasetFacetsBuilder builder = openLineage.newDatasetFacetsBuilder().schema(PlanUtils.schemaFacet(openLineage, schema)).lifecycleStateChange(openLineage.newLifecycleStateChangeDatasetFacet(lifecycleStateChange, null)).dataSource(PlanUtils.datasourceFacet(openLineage, di.get().getNamespace()));
        if (this.includeDatasetVersion(event)) {
            Optional<String> datasetVersion = CatalogUtils3.getDatasetVersion(this.context, tableCatalog, identifier, tableProperties);
            datasetVersion.ifPresent(version -> builder.version(openLineage.newDatasetVersionDatasetFacet((String)version)));
        }
        CatalogUtils3.getStorageDatasetFacet(this.context, tableCatalog, tableProperties).map(storageDatasetFacet -> builder.storage((OpenLineage.StorageDatasetFacet)storageDatasetFacet));
        return Collections.singletonList(this.outputDataset().getDataset(di.get(), builder));
    }
}

