/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.http.client.protocol;

import io.openlineage.spark.shaded.org.apache.http.HttpEntity;
import io.openlineage.spark.shaded.org.apache.http.HttpEntityEnclosingRequest;
import io.openlineage.spark.shaded.org.apache.http.HttpException;
import io.openlineage.spark.shaded.org.apache.http.HttpRequest;
import io.openlineage.spark.shaded.org.apache.http.HttpRequestInterceptor;
import io.openlineage.spark.shaded.org.apache.http.HttpVersion;
import io.openlineage.spark.shaded.org.apache.http.ProtocolVersion;
import io.openlineage.spark.shaded.org.apache.http.annotation.Contract;
import io.openlineage.spark.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.openlineage.spark.shaded.org.apache.http.client.config.RequestConfig;
import io.openlineage.spark.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.openlineage.spark.shaded.org.apache.http.protocol.HttpContext;
import io.openlineage.spark.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

