/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.core5.reactor;

import io.openlineage.spark.shaded.org.apache.hc.core5.io.CloseMode;
import io.openlineage.spark.shaded.org.apache.hc.core5.io.ModalCloseable;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;

abstract class InternalChannel
implements ModalCloseable {
    InternalChannel() {
    }

    abstract void onIOEvent(int var1) throws IOException;

    abstract void onTimeout(Timeout var1) throws IOException;

    abstract void onException(Exception var1);

    abstract Timeout getTimeout();

    abstract long getLastEventTime();

    final void handleIOEvent(int ops) {
        try {
            this.onIOEvent(ops);
        }
        catch (CancelledKeyException ex) {
            this.close(CloseMode.GRACEFUL);
        }
        catch (Exception ex) {
            this.onException(ex);
            this.close(CloseMode.GRACEFUL);
        }
    }

    final boolean checkTimeout(long currentTimeMillis) {
        Timeout timeout = this.getTimeout();
        if (!timeout.isDisabled()) {
            long timeoutMillis = timeout.toMilliseconds();
            long deadlineMillis = this.getLastEventTime() + timeoutMillis;
            if (currentTimeMillis > deadlineMillis) {
                try {
                    this.onTimeout(timeout);
                }
                catch (CancelledKeyException ex) {
                    this.close(CloseMode.GRACEFUL);
                }
                catch (Exception ex) {
                    this.onException(ex);
                    this.close(CloseMode.GRACEFUL);
                }
                return false;
            }
        }
        return true;
    }
}

