/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.client5.http.protocol;

import io.openlineage.spark.shaded.org.apache.hc.client5.http.RouteInfo;
import io.openlineage.spark.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.Contract;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.EntityDetails;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpException;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpRequest;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.Method;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestClientConnControl.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        String exchangeId = clientContext.getExchangeId();
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Connection route not set in the context", (Object)exchangeId);
            }
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "keep-alive");
        }
    }
}

