/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.client5.http.impl;

import io.openlineage.spark.shaded.org.apache.hc.client5.http.SchemePortResolver;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.Contract;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpHost;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.URIScheme;
import io.openlineage.spark.shaded.org.apache.hc.core5.net.NamedEndpoint;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) {
        Args.notNull(host, "HTTP host");
        return this.resolve(host.getSchemeName(), host);
    }

    @Override
    public int resolve(String scheme, NamedEndpoint endpoint) {
        Args.notNull(endpoint, "Endpoint");
        int port = endpoint.getPort();
        if (port > 0) {
            return port;
        }
        if (URIScheme.HTTP.same(scheme)) {
            return 80;
        }
        if (URIScheme.HTTPS.same(scheme)) {
            return 443;
        }
        return -1;
    }
}

