/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.api;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.runtime.AbstractPartialFunction;

public abstract class QueryPlanVisitor<T extends LogicalPlan, D extends OpenLineage.Dataset>
extends AbstractPartialFunction<LogicalPlan, List<D>> {
    @NonNull
    protected final OpenLineageContext context;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected QueryPlanVisitor(@NonNull OpenLineageContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    protected DatasetFactory<OpenLineage.OutputDataset> outputDataset() {
        return DatasetFactory.output(this.context);
    }

    protected DatasetFactory<OpenLineage.InputDataset> inputDataset() {
        return DatasetFactory.input(this.context);
    }

    protected Optional<CatalogTable> catalogTableFor(TableIdentifier tableId) {
        return this.context.getSparkSession().flatMap(session -> {
            try {
                return Optional.of(session.sessionState().catalog().getTableMetadata(tableId));
            }
            catch (Exception e) {
                this.logger.warn("Unable to find table by identifier {} - {}", (Object)tableId, (Object)e.getMessage());
                return Optional.empty();
            }
        });
    }

    public boolean isDefinedAt(LogicalPlan x) {
        Type genericSuperclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return false;
        }
        Type[] typeArgs = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
        if (typeArgs != null && typeArgs.length > 0) {
            Type arg = typeArgs[0];
            boolean isAssignable = ((Class)arg).isAssignableFrom(x.getClass());
            if (isAssignable) {
                this.logger.debug("Matched {} to logical plan {}", (Object)this, (Object)x);
            }
            return isAssignable;
        }
        return false;
    }

    public String toString() {
        Stream<Optional> typeArgs;
        Type genericSuperclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            typeArgs = Stream.of(Optional.empty(), Optional.empty());
        } else {
            Type[] actualArgs = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
            typeArgs = Arrays.stream(actualArgs).map(arg -> Optional.ofNullable(arg).map(Type::getTypeName));
        }
        String genericArgs = typeArgs.map(opt -> opt.orElse("?")).collect(Collectors.joining(","));
        return ((Object)((Object)this)).getClass().getName() + "<" + genericArgs + ">";
    }
}

