/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.api;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.lifecycle.UnknownEntryFacetListener;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.AbstractGenericArgPartialFunction;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.PartialFunction;

public abstract class AbstractQueryPlanDatasetBuilder<T, P extends LogicalPlan, D extends OpenLineage.Dataset>
extends AbstractGenericArgPartialFunction<T, D> {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryPlanDatasetBuilder.class);
    protected final OpenLineageContext context;
    private final UnknownEntryFacetListener unknownEntryFacetListener = UnknownEntryFacetListener.getInstance();
    protected final boolean searchDependencies;

    public AbstractQueryPlanDatasetBuilder(OpenLineageContext context, boolean searchDependencies) {
        this.context = context;
        this.searchDependencies = searchDependencies;
    }

    protected DatasetFactory<OpenLineage.OutputDataset> outputDataset() {
        return DatasetFactory.output(this.context);
    }

    protected DatasetFactory<OpenLineage.InputDataset> inputDataset() {
        return DatasetFactory.input(this.context);
    }

    public abstract List<D> apply(P var1);

    public final List<D> apply(T event) {
        return this.context.getQueryExecution().map(qe -> {
            QueryPlanVisitor visitor = this.asQueryPlanVisitor(event);
            if (this.searchDependencies) {
                return ScalaConversionUtils.fromSeq(qe.optimizedPlan().collect(visitor)).stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
            if (PlanUtils.safeIsDefinedAt(visitor, qe.optimizedPlan())) {
                return PlanUtils.safeApply(visitor, qe.optimizedPlan());
            }
            return Collections.emptyList();
        }).orElseGet(Collections::emptyList);
    }

    public <L extends LogicalPlan> QueryPlanVisitor<L, D> asQueryPlanVisitor(final T event) {
        final AbstractQueryPlanDatasetBuilder builder = this;
        return new QueryPlanVisitor<L, D>(this.context){

            @Override
            public boolean isDefinedAt(LogicalPlan x) {
                return builder.isDefinedAt(event) && AbstractQueryPlanDatasetBuilder.this.isDefinedAtLogicalPlan(x);
            }

            public List<D> apply(LogicalPlan x) {
                AbstractQueryPlanDatasetBuilder.this.unknownEntryFacetListener.accept(x);
                return builder.apply(event, x);
            }
        };
    }

    protected List<D> apply(T event, P plan) {
        return this.apply((T)plan);
    }

    protected PartialFunction<LogicalPlan, Collection<D>> delegate(Collection<PartialFunction<LogicalPlan, List<D>>> visitors, Collection<? extends PartialFunction<Object, Collection<D>>> builders, T event) {
        return PlanUtils.merge(Stream.concat(visitors.stream(), builders.stream().filter(builder -> builder instanceof AbstractQueryPlanDatasetBuilder && builder.isDefinedAt(event)).map(builder -> ((AbstractQueryPlanDatasetBuilder)builder).asQueryPlanVisitor(event))).collect(Collectors.toList()));
    }

    protected boolean isDefinedAtLogicalPlan(LogicalPlan logicalPlan) {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return false;
        }
        Type[] typeArgs = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
        if (typeArgs != null && typeArgs.length > 1) {
            Type arg = typeArgs[1];
            if (arg instanceof TypeVariable) {
                return false;
            }
            return ((Class)arg).isAssignableFrom(logicalPlan.getClass());
        }
        return false;
    }
}

