/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.util;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.Versions;
import io.openlineage.spark.agent.util.ReflectionUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.package$;
import org.apache.spark.rdd.HadoopRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.datasources.FileScanRDD;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.PartialFunction;
import scala.runtime.AbstractPartialFunction;

public class PlanUtils {
    private static final Logger log = LoggerFactory.getLogger(PlanUtils.class);
    public static final String SLASH_DELIMITER_USER_PASSWORD_REGEX = "[A-Za-z0-9_%]+//?[A-Za-z0-9_%]*@";
    public static final String COLON_DELIMITER_USER_PASSWORD_REGEX = "([/|,])[A-Za-z0-9_%]+:?[A-Za-z0-9_%]*@";

    public static <T, R> Collection<R> applyAll(List<? extends PartialFunction<T, ? extends Collection<R>>> fns, T arg) {
        PartialFunction fn = PlanUtils.merge(fns);
        if (fn.isDefinedAt(arg)) {
            return (Collection)fn.apply(arg);
        }
        return Collections.emptyList();
    }

    public static <T, D> PartialFunction<T, Collection<D>> merge(final Collection<? extends PartialFunction<T, ? extends Collection<D>>> fns) {
        return new AbstractPartialFunction<T, Collection<D>>(){

            public boolean isDefinedAt(T x) {
                return fns.stream().filter(pfn -> PlanUtils.safeIsDefinedAt(pfn, x)).findFirst().isPresent();
            }

            private boolean isDefinedAt(T x, PartialFunction<T, ? extends Collection<D>> pfn) {
                return PlanUtils.safeIsDefinedAt(pfn, x);
            }

            public Collection<D> apply(T x) {
                return fns.stream().filter(pfn -> PlanUtils.safeIsDefinedAt(pfn, x)).map(pfn -> {
                    try {
                        Collection collection = (Collection)pfn.apply(x);
                        if (log.isDebugEnabled()) {
                            log.debug("Visitor {} visited {}, returned {}", new Object[]{pfn.getClass().getCanonicalName(), x.getClass().getCanonicalName(), collection});
                        }
                        return collection;
                    }
                    catch (NoClassDefFoundError | NoSuchMethodError | RuntimeException e) {
                        log.error("Apply failed:", e);
                        return null;
                    }
                }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
            }
        };
    }

    public static OpenLineage.SchemaDatasetFacet schemaFacet(OpenLineage openLineage, StructType structType) {
        return openLineage.newSchemaDatasetFacetBuilder().fields(PlanUtils.transformFields(openLineage, structType.fields())).build();
    }

    private static List<OpenLineage.SchemaDatasetFacetFields> transformFields(OpenLineage openLineage, StructField ... fields) {
        ArrayList<OpenLineage.SchemaDatasetFacetFields> list = new ArrayList<OpenLineage.SchemaDatasetFacetFields>();
        for (StructField field : fields) {
            list.add(openLineage.newSchemaDatasetFacetFieldsBuilder().name(field.name()).type(field.dataType().typeName()).build());
        }
        return list;
    }

    public static StructType toStructType(List<Attribute> attributes) {
        return new StructType(attributes.stream().map(attr -> new StructField(attr.name(), attr.dataType(), attr.nullable(), attr.metadata())).collect(Collectors.toList()).toArray(new StructField[0]));
    }

    public static String namespaceUri(URI outputPath) {
        return Optional.ofNullable(outputPath.getAuthority()).map(a -> String.format("%s://%s", outputPath.getScheme(), a)).orElse(outputPath.getScheme());
    }

    public static OpenLineage.DatasourceDatasetFacet datasourceFacet(OpenLineage openLineage, String namespaceUri) {
        return openLineage.newDatasourceDatasetFacetBuilder().uri(URI.create(namespaceUri)).name(namespaceUri).build();
    }

    public static OpenLineage.ParentRunFacet parentRunFacet(UUID parentRunId, String parentJob, String parentJobNamespace) {
        return new OpenLineage(Versions.OPEN_LINEAGE_PRODUCER_URI).newParentRunFacetBuilder().run(new OpenLineage.ParentRunFacetRunBuilder().runId(parentRunId).build()).job(new OpenLineage.ParentRunFacetJobBuilder().name(parentJob).namespace(parentJobNamespace).build()).build();
    }

    public static Path getDirectoryPath(Path p, Configuration hadoopConf) {
        try {
            if (p.getFileSystem(hadoopConf).getFileStatus(p).isFile()) {
                return p.getParent();
            }
            return p;
        }
        catch (IOException e) {
            log.warn("Unable to get file system for path ", (Throwable)e);
            return p;
        }
    }

    public static List<Path> findRDDPaths(List<RDD<?>> fileRdds) {
        return fileRdds.stream().flatMap(rdd -> {
            if (rdd instanceof HadoopRDD) {
                HadoopRDD hadoopRDD = (HadoopRDD)rdd;
                Path[] inputPaths = FileInputFormat.getInputPaths((JobConf)hadoopRDD.getJobConf());
                Configuration hadoopConf = hadoopRDD.getConf();
                return Arrays.stream(inputPaths).map(p -> PlanUtils.getDirectoryPath(p, hadoopConf));
            }
            if (rdd instanceof FileScanRDD) {
                FileScanRDD fileScanRDD = (FileScanRDD)rdd;
                return ScalaConversionUtils.fromSeq(fileScanRDD.filePartitions()).stream().flatMap(fp -> Arrays.stream(fp.files())).map(f -> {
                    if (package$.MODULE$.SPARK_VERSION().compareTo("3.4") > 0) {
                        return ReflectionUtils.tryExecuteMethod(f, "filePath", new Object[0]).map(o -> ReflectionUtils.tryExecuteMethod(o, "toPath", new Object[0])).map(o -> (Path)o.get()).get().getParent();
                    }
                    return new Path(f.filePath()).getParent();
                });
            }
            log.warn("Unknown RDD class {}", (Object)rdd.getClass().getCanonicalName());
            return Stream.empty();
        }).distinct().collect(Collectors.toList());
    }

    public static boolean safeIsInstanceOf(Object instance, String classCanonicalName) {
        try {
            Class<?> c = Class.forName(classCanonicalName);
            return instance.getClass().isAssignableFrom(c);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean safeIsDefinedAt(PartialFunction pfn, Object x) {
        try {
            return pfn.isDefinedAt(x);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (Exception e) {
            if (e != null) {
                log.info("isDefinedAt method failed on {}", (Throwable)e);
            }
            return false;
        }
        catch (NoClassDefFoundError e) {
            log.info("isDefinedAt method failed on {}", (Object)e.getMessage());
            return false;
        }
    }

    public static <T, D> List<T> safeApply(PartialFunction<D, List<T>> pfn, D x) {
        try {
            return (List)pfn.apply(x);
        }
        catch (Exception | NoClassDefFoundError | NoSuchMethodError e) {
            log.info("apply method failed with", e);
            return Collections.emptyList();
        }
    }
}

