/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.util;

import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.client.utils.DatasetIdentifierUtils;
import io.openlineage.spark.agent.util.SparkConfUtils;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.internal.StaticSQLConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static final Logger log = LoggerFactory.getLogger(PathUtils.class);
    private static final String DEFAULT_SCHEME = "file";
    public static final String SPARK_OPENLINEAGE_DATASET_REMOVE_PATH_PATTERN = "spark.openlineage.dataset.removePath.pattern";
    public static final String REMOVE_PATTERN_GROUP = "remove";
    private static Optional<SparkConf> sparkConf = Optional.empty();

    public static DatasetIdentifier fromPath(Path path) {
        return PathUtils.fromPath(path, DEFAULT_SCHEME);
    }

    public static DatasetIdentifier fromPath(Path path, String defaultScheme) {
        return PathUtils.fromURI(path.toUri(), defaultScheme);
    }

    public static DatasetIdentifier fromURI(URI location) {
        return PathUtils.fromURI(location, DEFAULT_SCHEME);
    }

    public static DatasetIdentifier fromURI(URI location, String defaultScheme) {
        DatasetIdentifier di = DatasetIdentifierUtils.fromURI(location, defaultScheme);
        return new DatasetIdentifier(PathUtils.removePathPattern(di.getName()), di.getNamespace());
    }

    public static DatasetIdentifier fromCatalogTable(CatalogTable catalogTable) {
        return PathUtils.fromCatalogTable(catalogTable, PathUtils.loadSparkConf());
    }

    public static DatasetIdentifier fromCatalogTable(CatalogTable catalogTable, Optional<SparkConf> sparkConf) {
        DatasetIdentifier di;
        if (catalogTable.storage() != null && catalogTable.storage().locationUri().isDefined()) {
            di = PathUtils.fromURI((URI)catalogTable.storage().locationUri().get(), DEFAULT_SCHEME);
        } else {
            try {
                di = PathUtils.prepareDatasetIdentifierFromDefaultTablePath(catalogTable);
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException("Unable to extract DatasetIdentifier from a CatalogTable", e);
            }
        }
        Optional<URI> metastoreUri = PathUtils.extractMetastoreUri(sparkConf);
        if (metastoreUri.isPresent() && metastoreUri.get() != null) {
            DatasetIdentifier symlink = PathUtils.prepareHiveDatasetIdentifier(catalogTable, metastoreUri.get());
            return di.withSymlink(symlink.getName(), symlink.getNamespace(), DatasetIdentifier.SymlinkType.TABLE);
        }
        return di.withSymlink(PathUtils.nameFromTableIdentifier(catalogTable.identifier()), StringUtils.substringBeforeLast((String)di.getName(), (String)File.separator), DatasetIdentifier.SymlinkType.TABLE);
    }

    private static DatasetIdentifier prepareDatasetIdentifierFromDefaultTablePath(CatalogTable catalogTable) {
        URI uri = SparkSession.active().sessionState().catalog().defaultTablePath(catalogTable.identifier());
        return PathUtils.fromURI(uri);
    }

    private static DatasetIdentifier prepareHiveDatasetIdentifier(CatalogTable catalogTable, URI metastoreUri) {
        String qualifiedName = PathUtils.nameFromTableIdentifier(catalogTable.identifier());
        if (!qualifiedName.startsWith("/")) {
            qualifiedName = String.format("/%s", qualifiedName);
        }
        return PathUtils.fromPath(new Path(PathUtils.enrichHiveMetastoreURIWithTableName(metastoreUri, qualifiedName)));
    }

    public static URI enrichHiveMetastoreURIWithTableName(URI metastoreUri, String qualifiedName) {
        return new URI("hive", null, metastoreUri.getHost(), metastoreUri.getPort(), qualifiedName, null, null);
    }

    private static Optional<SparkConf> loadSparkConf() {
        if (!sparkConf.isPresent() && SparkSession.getDefaultSession().isDefined()) {
            sparkConf = Optional.of(((SparkSession)SparkSession.getDefaultSession().get()).sparkContext().getConf());
        }
        return sparkConf;
    }

    private static Optional<URI> extractMetastoreUri(Optional<SparkConf> sparkConf) {
        if (!sparkConf.isPresent()) {
            return Optional.empty();
        }
        Optional<String> setting = SparkConfUtils.findSparkConfigKey(sparkConf.get(), StaticSQLConf.CATALOG_IMPLEMENTATION().key());
        if (!setting.isPresent() || !"hive".equals(setting.get())) {
            return Optional.empty();
        }
        return SparkConfUtils.getMetastoreUri(sparkConf.get());
    }

    private static String removeFirstSlashIfSingleSlashInString(String name) {
        if (name.chars().filter(x -> x == 47).count() == 1L && name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    private static String removePathPattern(String datasetName) {
        return PathUtils.loadSparkConf().filter(conf -> conf.contains(SPARK_OPENLINEAGE_DATASET_REMOVE_PATH_PATTERN)).map(conf -> conf.get(SPARK_OPENLINEAGE_DATASET_REMOVE_PATH_PATTERN)).map(pattern -> Pattern.compile(pattern)).map(pattern -> pattern.matcher(datasetName)).filter(matcher -> matcher.find()).filter(matcher -> {
            try {
                matcher.group(REMOVE_PATTERN_GROUP);
                return true;
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                return false;
            }
        }).filter(matcher -> StringUtils.isNotEmpty((String)matcher.group(REMOVE_PATTERN_GROUP))).map(matcher -> datasetName.substring(0, matcher.start(REMOVE_PATTERN_GROUP)) + datasetName.substring(matcher.end(REMOVE_PATTERN_GROUP), datasetName.length())).orElse(datasetName);
    }

    private static String nameFromTableIdentifier(TableIdentifier identifier) {
        String name = identifier.database().isDefined() ? String.format("%s.%s", identifier.database().get(), identifier.table()) : identifier.table();
        return name;
    }
}

