/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.util;

import com.google.common.base.CharMatcher;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.sql.DbTableMeta;
import io.openlineage.sql.ExtractionError;
import io.openlineage.sql.OpenLineageSql;
import io.openlineage.sql.SqlMeta;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);

    public static String sanitizeJdbcUrl(String jdbcUrl) {
        return jdbcUrl.replaceFirst("^jdbc:", "").replaceFirst("^postgresql:", "postgres:").replaceAll("[A-Za-z0-9_%]+//?[A-Za-z0-9_%]*@", "@").replaceAll("([/|,])[A-Za-z0-9_%]+:?[A-Za-z0-9_%]*@", "$1").replaceAll("(?<=[?,;&:)=])\\(?(?i)(?:user|username|password)=[^;&,)]+(?:[;&;)]|$)", "").replaceAll("\\?.+$", "");
    }

    public static DatasetIdentifier getDatasetIdentifierFromJdbcUrl(String jdbcUrl, String name) {
        List<String> parts = Arrays.stream(name.split("\\.")).collect(Collectors.toList());
        return JdbcUtils.getDatasetIdentifierFromJdbcUrl(jdbcUrl, parts);
    }

    public static DatasetIdentifier getDatasetIdentifierFromJdbcUrl(String jdbcUrl, List<String> parts) {
        String namespace = jdbcUrl = JdbcUtils.sanitizeJdbcUrl(jdbcUrl);
        String urlDatabase = null;
        try {
            URI uri = new URI(jdbcUrl);
            String path = uri.getPath();
            if (path != null) {
                namespace = String.format("%s://%s", uri.getScheme(), uri.getAuthority());
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.length() > 1 && CharMatcher.forPredicate(Character::isAlphabetic).matchesAllOf((CharSequence)path)) {
                    urlDatabase = path;
                }
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        if (urlDatabase != null && parts.size() <= 3) {
            parts.add(0, urlDatabase);
        }
        String name = String.join((CharSequence)".", parts);
        return new DatasetIdentifier(name, namespace);
    }

    public static Optional<SqlMeta> extractQueryFromSpark(JDBCRelation relation) {
        String tableOrQuery = relation.jdbcOptions().tableOrQuery();
        if (!tableOrQuery.trim().startsWith("(")) {
            return Optional.of(new SqlMeta(Collections.singletonList(new DbTableMeta(null, null, tableOrQuery)), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
        }
        String query = tableOrQuery.substring(0, tableOrQuery.lastIndexOf(")")).replaceFirst("\\(", "");
        String dialect = JdbcUtils.extractDialectFromJdbcUrl(relation.jdbcOptions().url());
        SqlMeta sqlMeta = OpenLineageSql.parse(Collections.singletonList(query), dialect).get();
        if (!sqlMeta.errors().isEmpty()) {
            log.error(String.format("error while parsing query: %s", sqlMeta.errors().stream().map(ExtractionError::toString).collect(Collectors.joining(","))));
            return Optional.empty();
        }
        if (sqlMeta.inTables().isEmpty()) {
            log.error("no tables defined in query, this should not happen");
            return Optional.empty();
        }
        return Optional.of(sqlMeta);
    }

    private static String extractDialectFromJdbcUrl(String jdbcUrl) {
        Pattern pattern = Pattern.compile("^jdbc:([^:]+):.*");
        Matcher matcher = pattern.matcher(jdbcUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

