/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan.column;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.openlineage.sql.ColumnMeta;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnLevelLineageBuilder {
    private static final Logger log = LoggerFactory.getLogger(ColumnLevelLineageBuilder.class);
    private Map<ExprId, Set<ExprId>> exprDependencies = new HashMap<ExprId, Set<ExprId>>();
    private Map<ExprId, List<Pair<DatasetIdentifier, String>>> inputs = new HashMap<ExprId, List<Pair<DatasetIdentifier, String>>>();
    private Map<OpenLineage.SchemaDatasetFacetFields, ExprId> outputs = new HashMap<OpenLineage.SchemaDatasetFacetFields, ExprId>();
    private Map<ColumnMeta, ExprId> externalExpressionMappings = new HashMap<ColumnMeta, ExprId>();
    private final OpenLineage.SchemaDatasetFacet schema;
    private final OpenLineageContext context;

    public ColumnLevelLineageBuilder(@NonNull OpenLineage.SchemaDatasetFacet schema, @NonNull OpenLineageContext context) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.schema = schema;
        this.context = context;
    }

    public void addInput(ExprId exprId, DatasetIdentifier datasetIdentifier, String attributeName) {
        this.inputs.computeIfAbsent(exprId, k -> new LinkedList());
        Pair<DatasetIdentifier, String> input = Pair.of(datasetIdentifier, attributeName);
        if (!this.inputs.get(exprId).contains(input)) {
            this.inputs.get(exprId).add(input);
        }
    }

    public void addOutput(ExprId exprId, String attributeName) {
        this.schema.getFields().stream().filter(field -> field.getName().equals(attributeName)).findAny().ifPresent(field -> this.outputs.put((OpenLineage.SchemaDatasetFacetFields)field, exprId));
    }

    public void addDependency(ExprId parent, ExprId child) {
        this.exprDependencies.computeIfAbsent(parent, k -> new HashSet()).add(child);
    }

    public boolean hasOutputs() {
        return !this.outputs.isEmpty();
    }

    public Optional<ExprId> getOutputExprIdByFieldName(String field) {
        return this.outputs.keySet().stream().filter(fields -> fields.getName().equals(field)).findAny().map(f -> this.outputs.get(f));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ObjectMapper mapper = OpenLineageClientUtils.newObjectMapper();
        try {
            sb.append("Inputs: ").append(mapper.writeValueAsString(this.inputs)).append(System.lineSeparator());
            sb.append("Dependencies: ").append(mapper.writeValueAsString(this.exprDependencies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.toString())))).append(System.lineSeparator());
            sb.append("Outputs: ").append(mapper.writeValueAsString(this.outputs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.toString())))).append(System.lineSeparator());
        }
        catch (JsonProcessingException e2) {
            sb.append("Unable to serialize: ").append(e2.toString());
        }
        return sb.toString();
    }

    public OpenLineage.ColumnLineageDatasetFacetFields build() {
        OpenLineage.ColumnLineageDatasetFacetFieldsBuilder fieldsBuilder = this.context.getOpenLineage().newColumnLineageDatasetFacetFieldsBuilder();
        this.schema.getFields().stream().map(field -> Pair.of(field, this.getInputsUsedFor(field.getName()))).filter(pair -> !((List)pair.getRight()).isEmpty()).map(pair -> Pair.of(pair.getLeft(), this.facetInputFields((List)pair.getRight()))).forEach(pair -> fieldsBuilder.put(((OpenLineage.SchemaDatasetFacetFields)pair.getLeft()).getName(), this.context.getOpenLineage().newColumnLineageDatasetFacetFieldsAdditionalBuilder().inputFields((List)pair.getRight()).build()));
        return fieldsBuilder.build();
    }

    private List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields> facetInputFields(List<Pair<DatasetIdentifier, String>> inputFields) {
        return inputFields.stream().map(field -> new OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder().namespace(((DatasetIdentifier)field.getLeft()).getNamespace()).name(((DatasetIdentifier)field.getLeft()).getName()).field((String)field.getRight()).build()).collect(Collectors.toList());
    }

    List<Pair<DatasetIdentifier, String>> getInputsUsedFor(String outputName) {
        Optional<OpenLineage.SchemaDatasetFacetFields> outputField = this.schema.getFields().stream().filter(field -> field.getName().equalsIgnoreCase(outputName)).findAny();
        if (!outputField.isPresent() || !this.outputs.containsKey(outputField.get())) {
            return Collections.emptyList();
        }
        return this.findDependentInputs(this.outputs.get(outputField.get())).stream().filter(inputExprId -> this.inputs.containsKey(inputExprId)).flatMap(inputExprId -> this.inputs.get(inputExprId).stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private List<ExprId> findDependentInputs(ExprId outputExprId) {
        LinkedList<ExprId> dependentInputs = new LinkedList<ExprId>();
        dependentInputs.add(outputExprId);
        boolean continueSearch = true;
        Set<Object> newDependentInputs = new HashSet<ExprId>(Arrays.asList(outputExprId));
        while (continueSearch) {
            newDependentInputs = newDependentInputs.stream().filter(exprId -> this.exprDependencies.containsKey(exprId)).flatMap(exprId -> this.exprDependencies.get(exprId).stream()).filter(exprId -> !dependentInputs.contains(exprId)).collect(Collectors.toSet());
            dependentInputs.addAll(newDependentInputs);
            continueSearch = !newDependentInputs.isEmpty();
        }
        return dependentInputs;
    }

    public void addExternalMapping(ColumnMeta meta, ExprId exprid) {
        this.externalExpressionMappings.putIfAbsent(meta, exprid);
    }

    public ExprId getMapping(ColumnMeta columnMeta) {
        return this.externalExpressionMappings.get(columnMeta);
    }

    public Map<ExprId, List<Pair<DatasetIdentifier, String>>> getInputs() {
        return this.inputs;
    }
}

