/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.TruncateTableCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateTableCommandVisitor
extends QueryPlanVisitor<TruncateTableCommand, OpenLineage.OutputDataset> {
    private static final Logger log = LoggerFactory.getLogger(TruncateTableCommandVisitor.class);

    public TruncateTableCommandVisitor(OpenLineageContext context) {
        super(context);
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        TruncateTableCommand command = (TruncateTableCommand)x;
        Optional<CatalogTable> tableOpt = this.catalogTableFor(command.tableName());
        if (tableOpt.isPresent()) {
            CatalogTable table = tableOpt.get();
            DatasetIdentifier datasetIdentifier = PathUtils.fromCatalogTable(table);
            DatasetFactory<OpenLineage.OutputDataset> datasetFactory = this.outputDataset();
            return Collections.singletonList(datasetFactory.getDataset(datasetIdentifier, new OpenLineage.DatasetFacetsBuilder().schema(null).dataSource(PlanUtils.datasourceFacet(this.context.getOpenLineage(), datasetIdentifier.getNamespace())).lifecycleStateChange(this.context.getOpenLineage().newLifecycleStateChangeDatasetFacet(OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.TRUNCATE, null))));
        }
        return Collections.emptyList();
    }
}

