/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.lifecycle.Rdds;
import io.openlineage.spark.agent.lifecycle.plan.AbstractRDDNodeVisitor;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.execution.SQLExecutionRDD;

public class SqlExecutionRDDVisitor
extends AbstractRDDNodeVisitor<LogicalRDD, OpenLineage.InputDataset> {
    public SqlExecutionRDDVisitor(@NonNull OpenLineageContext context) {
        super(context, DatasetFactory.input(context));
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    @Override
    public boolean isDefinedAt(LogicalPlan x) {
        return x instanceof LogicalRDD && SqlExecutionRDDVisitor.containsSqlExecution((LogicalRDD)x);
    }

    public static boolean containsSqlExecution(LogicalRDD logicalRDD) {
        Set<RDD<?>> rdds = Rdds.flattenRDDs(logicalRDD.rdd());
        return !rdds.stream().filter(rdd -> rdd instanceof SQLExecutionRDD).map(SQLExecutionRDD.class::cast).collect(Collectors.toList()).isEmpty();
    }

    public List<OpenLineage.InputDataset> apply(LogicalPlan x) {
        return this.findInputDatasets(Rdds.findFileLikeRdds(((LogicalRDD)x).rdd()), x.schema());
    }
}

