/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.spark.api.java.Optional;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDWDatabricksVisitor<D extends OpenLineage.Dataset>
extends QueryPlanVisitor<LogicalPlan, D> {
    private static final Logger log = LoggerFactory.getLogger(SqlDWDatabricksVisitor.class);
    private final DatasetFactory<D> factory;
    private static final Pattern dbJdbcPattern = Pattern.compile("database=([^;]*);?");
    private static final Pattern serverJdbcPattern = Pattern.compile("jdbc:([^;]*);?");
    private static final String DATABRICKS_CLASS_NAME = "com.databricks.spark.sqldw.SqlDWRelation";
    private static final String SPARK3_TABLE_FIELD_NAME = "tableNameOrSubquery";
    private static final String SPARK2_TABLE_FIELD_NAME = "com$databricks$spark$sqldw$SqlDWRelation$$tableNameOrSubquery";

    public SqlDWDatabricksVisitor(OpenLineageContext context, DatasetFactory<D> factory) {
        super(context);
        this.factory = factory;
    }

    public static boolean hasSqlDWDatabricksClasses() {
        try {
            SqlDWDatabricksVisitor.class.getClassLoader().loadClass(DATABRICKS_CLASS_NAME);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isSqlDwRelationClass(LogicalPlan plan) {
        return plan instanceof LogicalRelation && DATABRICKS_CLASS_NAME.equals(((LogicalRelation)plan).relation().getClass().getName());
    }

    @Override
    public boolean isDefinedAt(LogicalPlan plan) {
        return this.isSqlDwRelationClass(plan);
    }

    private Optional<String> getName(BaseRelation relation) {
        String tableName = "";
        try {
            List<Field> relationFields = FieldUtils.getAllFieldsList(relation.getClass());
            for (Field f : relationFields) {
                if (SPARK3_TABLE_FIELD_NAME.equals(f.getName())) {
                    tableName = (String)FieldUtils.readField(relation, SPARK3_TABLE_FIELD_NAME, true);
                    continue;
                }
                if (!SPARK2_TABLE_FIELD_NAME.equals(f.getName())) continue;
                tableName = (String)FieldUtils.readField(relation, SPARK2_TABLE_FIELD_NAME, true);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.warn("Unable to discover SQLDW tableNameOrSubquery property");
            return Optional.empty();
        }
        if ("".equals(tableName)) {
            log.warn("Unable to discover SQLDW tableNameOrSubquery property");
            return Optional.empty();
        }
        if (tableName.startsWith("\"") && tableName.endsWith("\"")) {
            tableName = tableName.replace("\"", "");
        }
        if (tableName.startsWith("(")) {
            tableName = "COMPLEX";
        }
        return Optional.of((Object)tableName);
    }

    private Optional<String> getNameSpace(BaseRelation relation) {
        String jdbcUrl;
        try {
            Object fieldDetails = FieldUtils.readField(relation, "params", true);
            jdbcUrl = (String)MethodUtils.invokeMethod(fieldDetails, true, "jdbcUrl");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Unable to discover SQLDW jdbcUrl Parameters");
            return Optional.empty();
        }
        Matcher serverMatcher = serverJdbcPattern.matcher(jdbcUrl);
        boolean serverIsFound = serverMatcher.find();
        Matcher dbMatcher = dbJdbcPattern.matcher(jdbcUrl);
        boolean dbIsFound = dbMatcher.find();
        if (!dbIsFound || !serverIsFound) {
            log.warn("Unable to discover SQLDW database name or server name from jdbc url");
            return Optional.empty();
        }
        String databaseSubString = dbMatcher.group(1);
        String serverSubString = serverMatcher.group(1);
        String output = String.format("%s;database=%s;", serverSubString, databaseSubString);
        return Optional.of((Object)output);
    }

    public List<D> apply(LogicalPlan x) {
        BaseRelation relation = ((LogicalRelation)x).relation();
        Optional<String> name = this.getName(relation);
        Optional<String> namespace = this.getNameSpace(relation);
        List<Object> output = name.isPresent() && namespace.isPresent() ? Collections.singletonList(this.factory.getDataset((String)name.get(), (String)namespace.get(), relation.schema())) : Collections.emptyList();
        return output;
    }
}

