/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import net.snowflake.spark.snowflake.DefaultSource;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeRelation;
import net.snowflake.spark.snowflake.TableName;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.immutable.Map;

public class SnowflakeRelationVisitor<D extends OpenLineage.Dataset>
extends QueryPlanVisitor<LogicalRelation, D> {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeRelationVisitor.class);
    private final DatasetFactory<D> factory;
    private static final String SNOWFLAKE_CLASS_NAME = "net.snowflake.spark.snowflake.SnowflakeRelation";
    private static final String SNOWFLAKE_PROVIDER_CLASS_NAME = "net.snowflake.spark.snowflake.DefaultSource";
    private static final String SNOWFLAKE_PREFIX = "snowflake://";

    public SnowflakeRelationVisitor(OpenLineageContext context, DatasetFactory<D> factory) {
        super(context);
        this.factory = factory;
    }

    protected boolean isSnowflakeClass(LogicalPlan plan) {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(SNOWFLAKE_CLASS_NAME);
            return plan instanceof LogicalRelation && c.isAssignableFrom(((LogicalRelation)plan).relation().getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasSnowflakeClasses() {
        try {
            SnowflakeRelationVisitor.class.getClassLoader().loadClass(SNOWFLAKE_PROVIDER_CLASS_NAME);
            return true;
        }
        catch (Exception exception) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(SNOWFLAKE_PROVIDER_CLASS_NAME);
                return true;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }

    public static boolean isSnowflakeSource(CreatableRelationProvider provider) {
        return SnowflakeRelationVisitor.hasSnowflakeClasses() && provider instanceof DefaultSource;
    }

    @Override
    public boolean isDefinedAt(LogicalPlan plan) {
        return this.isSnowflakeClass(plan);
    }

    public List<D> apply(LogicalPlan x) {
        SnowflakeRelation relation = (SnowflakeRelation)((LogicalRelation)x).relation();
        Parameters.MergedParameters params = relation.params();
        String sfDatabase = params.sfDatabase();
        String sfSchema = params.sfSchema();
        String url = params.sfFullURL();
        String tableName = "COMPLEX";
        Option table = params.table();
        try {
            TableName tableNameObj = (TableName)table.getOrElse(null);
            if (tableNameObj != null) {
                tableName = tableNameObj.toString();
            }
        }
        catch (NullPointerException e) {
            log.warn("Unable to discover Snowflake table property");
        }
        url = url.replace("https://", "");
        String name = String.format("%s.%s.%s", sfDatabase, sfSchema, tableName);
        String namespace = String.format("%s%s", SNOWFLAKE_PREFIX, url);
        List<D> output = Collections.singletonList(this.factory.getDataset(name, namespace, relation.schema()));
        return output;
    }

    public static <D extends OpenLineage.Dataset> List<D> createSnowflakeDatasets(DatasetFactory<D> datasetFactory, Map<String, String> options, StructType schema) {
        java.util.Map<String, String> javaOptions = ScalaConversionUtils.fromMap(options);
        String tableName = javaOptions.get("dbtable");
        if (tableName == null) {
            tableName = "COMPLEX";
        }
        String sfSchema = javaOptions.get("sfschema");
        String sfUrl = javaOptions.get("sfurl");
        String sfDatabase = javaOptions.get("sfdatabase");
        sfUrl = sfUrl.replace("https://", "");
        String name = String.format("%s.%s.%s", sfDatabase, sfSchema, tableName);
        String namespace = String.format("%s%s", SNOWFLAKE_PREFIX, sfUrl);
        List<D> output = Collections.singletonList(datasetFactory.getDataset(name, namespace, schema));
        return output;
    }
}

