/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.lifecycle.Rdds;
import io.openlineage.spark.agent.lifecycle.plan.AbstractRDDNodeVisitor;
import io.openlineage.spark.agent.lifecycle.plan.SqlExecutionRDDVisitor;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.List;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.LogicalRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalRDDVisitor<D extends OpenLineage.Dataset>
extends AbstractRDDNodeVisitor<LogicalRDD, D> {
    private static final Logger log = LoggerFactory.getLogger(LogicalRDDVisitor.class);

    public LogicalRDDVisitor(OpenLineageContext context, DatasetFactory<D> datasetFactory) {
        super(context, datasetFactory);
    }

    @Override
    public boolean isDefinedAt(LogicalPlan x) {
        return x instanceof LogicalRDD && !Rdds.findFileLikeRdds(((LogicalRDD)x).rdd()).isEmpty() && !SqlExecutionRDDVisitor.containsSqlExecution((LogicalRDD)x);
    }

    public List<D> apply(LogicalPlan x) {
        LogicalRDD logicalRdd = (LogicalRDD)x;
        List<RDD<?>> fileRdds = Rdds.findFileLikeRdds(logicalRdd.rdd());
        return this.findInputDatasets(fileRdds, logicalRdd.schema());
    }
}

