/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.spark.api.java.Optional;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.Map;

public class KustoRelationVisitor<D extends OpenLineage.Dataset>
extends QueryPlanVisitor<LogicalRelation, D> {
    private static final Logger log = LoggerFactory.getLogger(KustoRelationVisitor.class);
    private final DatasetFactory<D> factory;
    private static final String KUSTO_CLASS_NAME = "com.microsoft.kusto.spark.datasource.KustoRelation";
    private static final String KUSTO_PROVIDER_CLASS_NAME = "com.microsoft.kusto.spark.datasource.DefaultSource";
    private static final String KUSTO_URL_SUFFIX = ".kusto.windows.net";
    private static final String KUSTO_PREFIX = "azurekusto://";

    public KustoRelationVisitor(OpenLineageContext context, DatasetFactory<D> factory) {
        super(context);
        this.factory = factory;
    }

    protected boolean isKustoClass(LogicalPlan plan) {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(KUSTO_CLASS_NAME);
            return plan instanceof LogicalRelation && c.isAssignableFrom(((LogicalRelation)plan).relation().getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isKustoSource(CreatableRelationProvider provider) {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(KUSTO_PROVIDER_CLASS_NAME);
            return c.isAssignableFrom(provider.getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasKustoClasses() {
        try {
            KustoRelationVisitor.class.getClassLoader().loadClass(KUSTO_PROVIDER_CLASS_NAME);
            return true;
        }
        catch (Exception exception) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(KUSTO_PROVIDER_CLASS_NAME);
                return true;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }

    @Override
    public boolean isDefinedAt(LogicalPlan plan) {
        return this.isKustoClass(plan);
    }

    private static Optional<String> getName(BaseRelation relation) {
        String tableName = "";
        try {
            Object query = FieldUtils.readField(relation, "query", true);
            tableName = (String)query;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.warn("Unable to discover Kusto table property");
            return Optional.empty();
        }
        if (StringUtils.isBlank(tableName)) {
            log.warn("Unable to discover Kusto table property");
            return Optional.empty();
        }
        if (StringUtils.countMatches((CharSequence)tableName, "|") > 0) {
            tableName = "COMPLEX";
        }
        return Optional.of((Object)tableName);
    }

    private static Optional<String> getNamespace(BaseRelation relation) {
        String url;
        try {
            Object kustoCoords = FieldUtils.readField(relation, "kustoCoordinates", true);
            Object clusterUrl = FieldUtils.readField(kustoCoords, "clusterUrl", true);
            Object database = FieldUtils.readField(kustoCoords, "database", true);
            String kustoUrl = (String)clusterUrl;
            kustoUrl = kustoUrl.replace("https://", "");
            String databaseName = (String)database;
            url = String.format("%s%s/%s", KUSTO_PREFIX, kustoUrl, databaseName);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.warn("Unable to discover clusterUrl or database property");
            return Optional.empty();
        }
        if ("".equals(url)) {
            return Optional.empty();
        }
        return Optional.of((Object)url);
    }

    public static <D extends OpenLineage.Dataset> List<D> createKustoDatasets(DatasetFactory<D> datasetFactory, Map<String, String> options, StructType schema) {
        java.util.Map<String, String> javaOptions = ScalaConversionUtils.fromMap(options);
        String name = javaOptions.get("kustotable");
        String database = javaOptions.get("kustodatabase");
        String kustoCluster = javaOptions.get("kustocluster");
        String namespace = String.format("%s%s%s/%s", KUSTO_PREFIX, kustoCluster, KUSTO_URL_SUFFIX, database);
        List<D> output = Collections.singletonList(datasetFactory.getDataset(name, namespace, schema));
        return output;
    }

    public List<D> apply(LogicalPlan x) {
        BaseRelation relation = ((LogicalRelation)x).relation();
        Optional<String> name = KustoRelationVisitor.getName(relation);
        Optional<String> namespace = KustoRelationVisitor.getNamespace(relation);
        List<Object> output = name.isPresent() && namespace.isPresent() ? Collections.singletonList(this.factory.getDataset((String)name.get(), (String)namespace.get(), relation.schema())) : Collections.emptyList();
        return output;
    }
}

