/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.hive.execution.InsertIntoHiveTable;

public class InsertIntoHiveTableVisitor
extends QueryPlanVisitor<InsertIntoHiveTable, OpenLineage.OutputDataset> {
    public InsertIntoHiveTableVisitor(OpenLineageContext context) {
        super(context);
    }

    public static boolean hasHiveClasses() {
        try {
            InsertIntoHiveTableVisitor.class.getClassLoader().loadClass("org.apache.spark.sql.hive.execution.InsertIntoHiveTable");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        InsertIntoHiveTable cmd = (InsertIntoHiveTable)x;
        CatalogTable table = cmd.table();
        OpenLineage.OutputDataset outputDataset = cmd.overwrite() ? this.outputDataset().getDataset(PathUtils.fromCatalogTable(table), table.schema(), OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE) : this.outputDataset().getDataset(PathUtils.fromCatalogTable(table), table.schema());
        return Collections.singletonList(outputDataset);
    }
}

