/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import com.google.common.collect.ImmutableMap;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.DatasetFacetsUtils;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.InsertIntoDataSourceCommand;

public class InsertIntoDataSourceVisitor
extends QueryPlanVisitor<InsertIntoDataSourceCommand, OpenLineage.OutputDataset> {
    public InsertIntoDataSourceVisitor(OpenLineageContext context) {
        super(context);
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        InsertIntoDataSourceCommand command = (InsertIntoDataSourceCommand)x;
        return PlanUtils.applyAll(this.context.getOutputDatasetQueryPlanVisitors(), command.logicalRelation()).stream().map(ds -> {
            ImmutableMap.Builder facetsMap = ImmutableMap.builder();
            if (ds.getFacets().getAdditionalProperties() != null) {
                facetsMap.putAll(ds.getFacets().getAdditionalProperties());
            }
            ds.getFacets().getAdditionalProperties().putAll((Map<String, OpenLineage.DatasetFacet>)facetsMap.build());
            if (command.overwrite()) {
                OpenLineage.DatasetFacets facets = DatasetFacetsUtils.copyToBuilder(this.context, ds.getFacets()).lifecycleStateChange(this.context.getOpenLineage().newLifecycleStateChangeDatasetFacet(OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE, null)).build();
                OpenLineage.OutputDataset newDs = this.context.getOpenLineage().newOutputDataset(ds.getNamespace(), ds.getName(), facets, ds.getOutputFacets());
                return newDs;
            }
            return ds;
        }).collect(Collectors.toList());
    }
}

