/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.AbstractQueryPlanDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoDir;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.InsertIntoDataSourceDirCommand;
import org.apache.spark.sql.execution.datasources.InsertIntoDataSourceCommand;
import org.apache.spark.sql.execution.datasources.SaveIntoDataSourceCommand;
import scala.Function1;
import scala.PartialFunction;

public class CommandPlanVisitor
extends AbstractQueryPlanDatasetBuilder<SparkListenerEvent, LogicalPlan, OpenLineage.InputDataset> {
    public static final Function1<LogicalPlan, List<OpenLineage.InputDataset>> EMPTY_COLLECTION_FN = ScalaConversionUtils.toScalaFn(lp -> Collections.emptyList());

    public CommandPlanVisitor(OpenLineageContext context) {
        super(context, true);
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan x) {
        return x instanceof SaveIntoDataSourceCommand || x instanceof InsertIntoDir || x instanceof InsertIntoDataSourceCommand || x instanceof InsertIntoDataSourceDirCommand;
    }

    @Override
    public boolean isDefinedAt(SparkListenerEvent x) {
        return super.isDefinedAt(x) && this.context.getQueryExecution().filter(qe -> this.isDefinedAtLogicalPlan(qe.optimizedPlan())).isPresent();
    }

    @Override
    public List<OpenLineage.InputDataset> apply(LogicalPlan x) {
        Optional<LogicalPlan> input = this.getInput(x);
        return input.map(in -> ScalaConversionUtils.fromSeq(in.collect(PlanUtils.merge(this.context.getInputDatasetQueryPlanVisitors()))).stream().flatMap(Collection::stream).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    @Override
    public List<OpenLineage.InputDataset> apply(SparkListenerEvent event, LogicalPlan plan) {
        Optional<LogicalPlan> input = this.getInput(plan);
        PartialFunction<LogicalPlan, Collection<OpenLineage.InputDataset>> delegateFn = this.delegate(this.context.getInputDatasetQueryPlanVisitors(), this.context.getInputDatasetBuilders(), event);
        return input.map(in -> in.collect(delegateFn)).map(ScalaConversionUtils::fromSeq).orElse(Collections.emptyList()).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Optional<LogicalPlan> getInput(LogicalPlan x) {
        if (x instanceof SaveIntoDataSourceCommand) {
            return Optional.of(((SaveIntoDataSourceCommand)x).query());
        }
        if (x instanceof InsertIntoDir) {
            return Optional.of(((InsertIntoDir)x).child());
        }
        if (x instanceof InsertIntoDataSourceCommand) {
            return Optional.of(((InsertIntoDataSourceCommand)x).query());
        }
        if (x instanceof InsertIntoDataSourceDirCommand) {
            return Optional.of(((InsertIntoDataSourceDirCommand)x).query());
        }
        return Optional.empty();
    }
}

